/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.storage.SmallTankEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.StackContext;

public class SmallFluidTank
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public SmallFluidTank(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmallTankEntity(pos, state, false);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((ComparatorOutputProvider)world.getBlockEntity(pos)).getComparatorOutput();
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SmallTankEntity) {
            StackContext stackRef;
            FluidApi.FluidStorage candidate;
            SmallTankEntity tankEntity = (SmallTankEntity)blockEntity;
            ItemStack usedStack = stack;
            if (stack.getCount() > 1) {
                usedStack = stack.copyWithCount(1);
            }
            if ((candidate = FluidApi.ITEM.find(stackRef = new StackContext(usedStack, updated -> {
                if (stack.getCount() > 1) {
                    stack.shrink(1);
                    if (!player.getInventory().add(updated)) {
                        player.drop(updated, true);
                    }
                } else {
                    player.setItemInHand(hand, updated);
                }
            }))) != null) {
                if (!world.isClientSide) {
                    if (candidate.getContent().getFirst().isEmpty()) {
                        long moved = FluidApi.transferFirst(tankEntity.fluidStorage, candidate, tankEntity.fluidStorage.getCapacity(), false);
                        Oritech.LOGGER.debug("moved to item {} {}", (Object)moved, (Object)stackRef.getValue());
                    } else {
                        long moved = FluidApi.transferFirst(candidate, tankEntity.fluidStorage, tankEntity.fluidStorage.getCapacity(), false);
                        Oritech.LOGGER.debug("moved from item {} {}", (Object)moved, (Object)stackRef.getValue());
                    }
                }
                world.playLocalSound(pos, SoundEvents.AXOLOTL_SPLASH, SoundSource.PLAYERS, 0.8f, 1.4f, true);
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List droppedStacks = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof SmallTankEntity) {
            SmallTankEntity tankEntity = (SmallTankEntity)blockEntity;
            droppedStacks.addAll(tankEntity.inventory.getHeldStacks());
            tankEntity.inventory.clearContent();
        }
        return droppedStacks;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return SmallFluidTank.getStackWithData(world, pos);
    }

    @NotNull
    private static ItemStack getStackWithData(LevelReader world, BlockPos pos) {
        SmallTankEntity tankEntity = (SmallTankEntity)world.getBlockEntity(pos);
        ItemStack stack = SmallFluidTank.getBasePickStack(tankEntity.isCreative);
        if (tankEntity.fluidStorage.getAmount() > 0L) {
            FluidStack fluidStack = tankEntity.fluidStorage.getStack().copy();
            stack.set(FluidApi.ITEM.getFluidComponent(), (Object)fluidStack);
            stack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        }
        return stack;
    }

    public static ItemStack getBasePickStack(boolean creative) {
        return new ItemStack((ItemLike)(creative ? BlockContent.CREATIVE_TANK_BLOCK.asItem() : BlockContent.SMALL_TANK_BLOCK.asItem()));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (itemStack.has(FluidApi.ITEM.getFluidComponent())) {
            SmallTankEntity tankEntity = (SmallTankEntity)world.getBlockEntity(pos);
            tankEntity.fluidStorage.setStack(((FluidStack)itemStack.get(FluidApi.ITEM.getFluidComponent())).copy());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }
}

