/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.decorative;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.block.blocks.decorative.TechDoorBlock;
import rearth.oritech.init.BlockEntitiesContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TechDoorBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public static final RawAnimation OPEN = RawAnimation.begin().thenPlayAndHold("door_open");
    public static final RawAnimation CLOSE = RawAnimation.begin().thenPlayAndHold("door_close");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<TechDoorBlockEntity> animationController = this.getAnimationController();
    private long lastSoundEventAt = 0L;

    public TechDoorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.TECH_DOOR_ENTITY, pos, state);
    }

    public boolean shouldPlaySoundAgain() {
        long age = this.level.getGameTime() - this.lastSoundEventAt;
        this.lastSoundEventAt = this.level.getGameTime();
        return age > 40L;
    }

    private AnimationController<TechDoorBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            Boolean opened;
            if (state.getController().getCurrentAnimation() == null) {
                state.getController().setAnimationSpeed(100.0);
                TechDoorBlockEntity.delayedTimerReset((AnimationState<TechDoorBlockEntity>)state);
            }
            if ((opened = (Boolean)this.getBlockState().getValue((Property)TechDoorBlock.OPENED)).booleanValue()) {
                return state.setAndContinue(OPEN);
            }
            return state.setAndContinue(CLOSE);
        });
    }

    private static void delayedTimerReset(final AnimationState<TechDoorBlockEntity> state) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                state.getController().setAnimationSpeed(1.0);
            }
        }, 1000L);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

