/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ExpandableMultiblockEnergyStorageBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class LargeStorageBlockEntity
extends ExpandableMultiblockEnergyStorageBlockEntity
implements RedstoneAddonBlockEntity.RedstoneControllable {
    public LargeStorageBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.LARGE_STORAGE_ENTITY, pos, state);
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, 1, -1), new Vec3i(0, 1, 1), new Vec3i(1, 0, -1), new Vec3i(1, 0, 1), new Vec3i(1, 1, -1), new Vec3i(1, 1, 1));
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.largeEnergyStorage.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.largeEnergyStorage.maxEnergyInsertion();
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.largeEnergyStorage.maxEnergyExtraction();
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0));
    }

    @Override
    public int getComparatorEnergyAmount() {
        if (this.energyStorage.amount == 0L) {
            return 0;
        }
        return (int)(1.0f + (float)this.energyStorage.amount / (float)this.energyStorage.capacity * 14.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        ItemStack stack = this.inventory.getItem(slot);
        if (stack.isEmpty()) {
            return 0;
        }
        return (int)(1.0f + (float)stack.getCount() / (float)stack.getMaxStackSize() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        return 0;
    }

    @Override
    public int getComparatorActiveState() {
        return 15;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.setRedstonePowered(isPowered);
    }
}

