/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.block.entity.pipes.ItemPipeInterfaceEntity;

public class ItemPipeTransferRenderer
implements BlockEntityRenderer<ItemPipeInterfaceEntity> {
    public void render(ItemPipeInterfaceEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.activeStacks == null || entity.activeStacks.isEmpty()) {
            return;
        }
        float time = (float)entity.getLevel().getGameTime() + tickDelta;
        HashSet<ItemPipeInterfaceEntity.RenderStackData> removedStacks = new HashSet<ItemPipeInterfaceEntity.RenderStackData>();
        for (ItemPipeInterfaceEntity.RenderStackData renderedStack : entity.activeStacks) {
            double neededTime;
            float age = time - (float)renderedStack.startedAt().longValue();
            double progress = (double)age / (neededTime = ItemPipeInterfaceEntity.calculatePathLength(renderedStack.pathLength()));
            if (progress > 1.0) {
                removedStacks.add(renderedStack);
                continue;
            }
            progress = ItemPipeTransferRenderer.sigmoidFitted(progress);
            double targetPathProgress = (double)renderedStack.pathLength() * progress;
            int pathProgress = 0;
            BlockPos pathPosition = renderedStack.path().getFirst();
            Vec3 targetPos = Vec3.ZERO;
            for (BlockPos segment : renderedStack.path()) {
                int segmentDist = segment.distManhattan((Vec3i)pathPosition);
                if ((double)(pathProgress + segmentDist) < targetPathProgress) {
                    pathProgress += segmentDist;
                    pathPosition = segment;
                    continue;
                }
                double remainingDist = targetPathProgress - (double)pathProgress;
                Vec3 targetOffset = Vec3.atLowerCornerOf((Vec3i)segment.subtract((Vec3i)pathPosition)).normalize().scale(remainingDist);
                targetPos = Vec3.atLowerCornerOf((Vec3i)pathPosition).add(targetOffset);
                break;
            }
            Vec3 offset = targetPos.subtract(Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos()));
            matrices.pushPose();
            matrices.translate(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5);
            matrices.scale(0.4f, 0.4f, 0.4f);
            matrices.mulPose(Axis.YP.rotationDegrees(-140.0f));
            matrices.mulPose(Axis.XP.rotationDegrees(-30.0f));
            ItemStack renderedItem = renderedStack.rendered();
            Minecraft.getInstance().getItemRenderer().renderStatic(renderedItem, ItemDisplayContext.GUI, light, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 0);
            matrices.popPose();
        }
        entity.activeStacks.removeAll(removedStacks);
    }

    private static double sigmoidFitted(double x) {
        return ItemPipeTransferRenderer.sigmoid((x - 0.5) * 2.0) + 0.5;
    }

    private static double sigmoid(double x) {
        return x / (1.0 + Math.abs(x));
    }
}

