/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.CatalystScreenHandler;
import rearth.oritech.util.ScreenProvider;

public class CatalystScreen
extends BasicMachineScreen<CatalystScreenHandler> {
    public static final ResourceLocation GUI_COMPONENTS = Oritech.id("textures/gui/modular/machine_gui_components_souls.png");
    public static final ResourceLocation BOOK_SLOT = Oritech.id("textures/gui/modular/book_slot_background.png");
    private LabelComponent costLabel;
    private LabelComponent stabilizationLabel;

    public CatalystScreen(CatalystScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Override
    public ResourceLocation getGuiComponents() {
        return GUI_COMPONENTS;
    }

    @Override
    public boolean showExtensionPanel() {
        return false;
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        this.costLabel = Components.label((Component)Component.translatable((String)"message.oritech.catalyst.cost", (Object[])new Object[]{0}));
        this.stabilizationLabel = Components.label((Component)Component.translatable((String)"title.oritech.catalyst.stable"));
        overlay.child((io.wispforest.owo.ui.core.Component)this.costLabel.positioning(Positioning.absolute((int)56, (int)58)));
        overlay.child((io.wispforest.owo.ui.core.Component)this.stabilizationLabel.positioning(Positioning.absolute((int)108, (int)39)));
        ScreenProvider.GuiSlot slotConfig = ((CatalystScreenHandler)this.menu).screenData.getGuiSlots().getFirst();
        overlay.child((io.wispforest.owo.ui.core.Component)Components.texture((ResourceLocation)BOOK_SLOT, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).positioning(Positioning.absolute((int)slotConfig.x(), (int)slotConfig.y())));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        int cost = ((CatalystScreenHandler)this.menu).catalyst.getDisplayedCost();
        this.costLabel.text((Component)Component.translatable((String)"message.oritech.catalyst.cost", (Object[])new Object[]{cost}).withStyle(ChatFormatting.BLACK));
        if (cost == 0) {
            this.costLabel.zIndex(-5);
        } else {
            this.costLabel.zIndex(1);
        }
        MutableComponent result = this.getStabilizationTitle();
        this.stabilizationLabel.text((Component)result.withStyle(ChatFormatting.BLACK));
    }

    @NotNull
    private MutableComponent getStabilizationTitle() {
        int currentSouls = ((CatalystScreenHandler)this.menu).catalyst.collectedSouls;
        int baseSouls = ((CatalystScreenHandler)this.menu).catalyst.baseSoulCapacity;
        int maxSouls = ((CatalystScreenHandler)this.menu).catalyst.maxSouls;
        int soulBonus = maxSouls - baseSouls;
        int free = maxSouls - currentSouls;
        MutableComponent result = Component.translatable((String)"title.oritech.catalyst.stable");
        result = soulBonus > 0 && currentSouls >= baseSouls ? (free > 5 ? Component.translatable((String)"title.oritech.catalyst.stabilized") : (free > 0 ? Component.translatable((String)"title.oritech.catalyst.semi_stable") : Component.translatable((String)"title.oritech.catalyst.unstable"))) : (free > 5 ? Component.translatable((String)"title.oritech.catalyst.stable") : (free > 0 ? Component.translatable((String)"title.oritech.catalyst.semi_stable") : Component.translatable((String)"title.oritech.catalyst.stable")));
        return result;
    }

    @Override
    protected void updateEnergyBar() {
        int capacity = ((CatalystScreenHandler)this.menu).catalyst.maxSouls;
        int amount = ((CatalystScreenHandler)this.menu).catalyst.collectedSouls;
        float fillAmount = (float)amount / (float)capacity;
        Component tooltipText = this.getSoulTooltip(amount, capacity);
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }

    public Component getSoulTooltip(long amount, long max) {
        return Component.translatable((String)"tooltip.oritech.spawner.collected_souls", (Object[])new Object[]{amount, max});
    }
}

