/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.util.TooltipHelper;

public class SmallEnergyStorageBlockItem
extends BlockItem
implements EnergyApi.ItemProvider {
    public SmallEnergyStorageBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Long storedEnergy = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (storedEnergy != 0L) {
            MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_stored", (Object[])new Object[]{TooltipHelper.getEnergyText(storedEnergy)});
            tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public boolean isBarVisible(ItemStack stack) {
        boolean contentEmpty = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L) <= 0L;
        return !contentEmpty;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    public int getBarWidth(ItemStack stack) {
        long capacity = Oritech.CONFIG.smallEnergyStorage.energyCapacity();
        Long fillAmount = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        return Math.round((float)fillAmount.longValue() * 100.0f / (float)capacity * 13.0f) / 100;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(ItemStack stack) {
        return new SimpleEnergyItemStorage(Oritech.CONFIG.smallEnergyStorage.maxEnergyInsertion(), Oritech.CONFIG.smallEnergyStorage.maxEnergyExtraction(), Oritech.CONFIG.smallEnergyStorage.energyCapacity(), stack);
    }
}

