/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.init.SoundContent;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.TooltipHelper;

public class ElectricMaceItem
extends MaceItem
implements OritechEnergyItem {
    private static final int BASE_ATTACK_DAMAGE = Oritech.CONFIG.electricMace.baseDamage();
    private static final int RF_USAGE = Oritech.CONFIG.electricMace.energyUsage();
    public static final Map<Long, Runnable> PENDING_LIGHTNING_HITS = new HashMap<Long, Runnable>();

    public ElectricMaceItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)BASE_ATTACK_DAMAGE, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Oritech.id("mace_fall_protection"), 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Oritech.id("mace_reach"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        float bonus = 0.0f;
        boolean usedEnergy = this.tryUseEnergy(stack, RF_USAGE, null);
        if (usedEnergy && ElectricMaceItem.canSmashAttack((LivingEntity)attacker)) {
            attacker.level().playSound(null, target.blockPosition(), SoundContent.ELECTRIC_SHOCK, SoundSource.PLAYERS);
            attacker.resetFallDistance();
            bonus = this.getAttackDamageBonus((Entity)target, BASE_ATTACK_DAMAGE, new DamageSource((Holder)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.LIGHTNING_BOLT), (Entity)attacker));
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                if (player.getCooldowns().isOnCooldown((Item)this)) {
                    return;
                }
                player.getCooldowns().addCooldown((Item)this, 40);
                this.createLightningAttack(serverWorld, player, target, stack, (int)((float)BASE_ATTACK_DAMAGE / 2.0f + bonus / 2.0f));
            }
        }
    }

    private void createLightningAttack(ServerLevel world, Player attacker, LivingEntity target, ItemStack stack, int damage) {
        Level level;
        boolean usedEnergy = this.tryUseEnergy(stack, RF_USAGE * Oritech.CONFIG.electricMace.lightningCostMultiplier(), null);
        if (usedEnergy && (level = attacker.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 playerPos = attacker.getEyePosition();
            Vec3 targetPos = target.getEyePosition();
            Vec3 offset = targetPos.subtract(playerPos);
            Vec3 up = new Vec3(0.0, 1.0, 0.0);
            Vec3 cross = offset.cross(up).normalize();
            Vec3 pos = targetPos.add(cross.scale(14.0)).offsetRandom(serverWorld.random, 3.0f).add(0.0, 7.0, 0.0);
            ElectricMaceItem.createLightningBolt(serverWorld, pos, target.getEyePosition().offsetRandom(serverWorld.random, 0.1f), 10, 0.8f, 4.0, (ParticleOptions)ParticleTypes.ENCHANTED_HIT, 0.35f, 2, 0);
            for (int i = 1; i <= 5; ++i) {
                Vec3 ownPos = targetPos.add(cross.yRot((float)(i * 90)).scale(14.0)).offsetRandom(serverWorld.random, 5.0f).add(0.0, 7.0, 0.0);
                PENDING_LIGHTNING_HITS.put(serverWorld.getGameTime() + (long)(10 * i), () -> {
                    ElectricMaceItem.createLightningBolt(serverWorld, ownPos, target.getEyePosition().offsetRandom(serverWorld.random, 0.1f), 10, 0.8f, 4.0, (ParticleOptions)ParticleTypes.ENCHANTED_HIT, 0.35f, 2, 0);
                    target.hurtTime = 0;
                    target.hurt(new DamageSource((Holder)serverWorld.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.LIGHTNING_BOLT), (Entity)attacker), (float)damage);
                });
            }
        }
    }

    public static void processLightningEvents(Level world) {
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Map.Entry<Long, Runnable> entry : PENDING_LIGHTNING_HITS.entrySet()) {
            Long key = entry.getKey();
            if (world.getGameTime() <= key) continue;
            Runnable event = entry.getValue();
            event.run();
            toRemove.add(key);
        }
        toRemove.forEach(PENDING_LIGHTNING_HITS::remove);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        Entity attacker = damageSource.getDirectEntity();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            if (!ElectricMaceItem.canSmashAttack((LivingEntity)livingEntity)) {
                return 0.0f;
            }
            float fallDist = livingEntity.fallDistance;
            float damage = fallDist <= 3.0f ? (float)BASE_ATTACK_DAMAGE * fallDist : (fallDist <= 8.0f ? (float)(BASE_ATTACK_DAMAGE * 4) + 4.0f * (fallDist - 3.0f) : (float)(BASE_ATTACK_DAMAGE * 6) + fallDist - 8.0f);
            Level world = livingEntity.level();
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                return damage + EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverWorld, (ItemStack)livingEntity.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)2.0f) * fallDist;
            }
            return damage;
        }
        return 0.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack))});
        tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.electric_mace").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.electric_mace.1").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.electricMace.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return this.getEnergyCapacity(stack) / 10L;
    }

    public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(Player player, ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        return false;
    }

    public static void createLightningBolt(ServerLevel level, Vec3 startPos, Vec3 endPos, int mainSegments, double jitterAmount, double particlesPerMeter, ParticleOptions particleEffect, float branchChance, int maxBranchDepth, int currentBranchDepth) {
        RandomSource random = level.getRandom();
        Vec3 direction = endPos.subtract(startPos);
        double totalDistance = direction.length();
        if (totalDistance < 0.1) {
            level.sendParticles(particleEffect, startPos.x, startPos.y, startPos.z, 5, 0.1, 0.1, 0.1, 0.05);
            return;
        }
        Vec3 segmentVector = direction.normalize().scale(totalDistance / (double)mainSegments);
        Vec3 previousPoint = startPos;
        if (currentBranchDepth == 0) {
            level.playSound(null, endPos.x, endPos.y, endPos.z, SoundContent.ELECTRIC_SHOCK, SoundSource.PLAYERS, 0.8f, 0.5f + level.random.nextFloat() * 0.8f);
        }
        for (int i = 0; i < mainSegments; ++i) {
            Vec3 currentTargetPoint;
            if (i < mainSegments - 1) {
                currentTargetPoint = startPos.add(segmentVector.scale((double)(i + 1)));
                currentTargetPoint = currentTargetPoint.add((random.nextDouble() - 0.5) * 2.0 * jitterAmount, (random.nextDouble() - 0.5) * 2.0 * jitterAmount, (random.nextDouble() - 0.5) * 2.0 * jitterAmount);
            } else {
                currentTargetPoint = endPos;
            }
            ElectricMaceItem.spawnParticlesAlongSegment(level, previousPoint, currentTargetPoint, particlesPerMeter, particleEffect);
            if (currentBranchDepth < maxBranchDepth && random.nextFloat() < branchChance && i < mainSegments - 1) {
                Vec3 branchEndOffset = new Vec3((random.nextDouble() - 0.5) * totalDistance * 0.3, (random.nextDouble() - 0.5) * totalDistance * 0.3, (random.nextDouble() - 0.5) * totalDistance * 0.3);
                Vec3 branchEnd = currentTargetPoint.add(branchEndOffset);
                ElectricMaceItem.createLightningBolt(level, currentTargetPoint, branchEnd, Math.max(1, mainSegments / 2), jitterAmount * 0.7, particlesPerMeter * 0.7, particleEffect, branchChance * 0.5f, maxBranchDepth, currentBranchDepth + 1);
            }
            previousPoint = currentTargetPoint;
        }
    }

    private static void spawnParticlesAlongSegment(ServerLevel level, Vec3 p1, Vec3 p2, double particlesPerMeter, ParticleOptions particleEffect) {
        Vec3 segment = p2.subtract(p1);
        double length = segment.length();
        if (length < 0.01) {
            return;
        }
        Vec3 unit = segment.normalize();
        int numParticles = Math.max(1, (int)(length * particlesPerMeter));
        for (int i = 0; i < numParticles; ++i) {
            double progress = (double)i / (double)numParticles;
            Vec3 particlePos = p1.add(unit.scale(length * progress));
            level.sendParticles(particleEffect, particlePos.x, particlePos.y, particlePos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

