/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.Protection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PortableLaserRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.TooltipHelper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortableLaserItem
extends Item
implements OritechEnergyItem,
GeoItem {
    public static final int ACTION_COOLDOWN = 24;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation SHOOTING = RawAnimation.begin().thenPlay("shooting");
    private static final RawAnimation SINGLE_SHOT = RawAnimation.begin().thenPlay("singleshot");
    public static long lastSingleShot = 0L;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Map<Player, Tuple<BlockPos, Integer>> blockBreakStats = new HashMap<Player, Tuple<BlockPos, Integer>>();

    public PortableLaserItem(Item.Properties settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        EntityHitResult entityHitResult;
        Entity entity;
        Vec3 endPos;
        ItemStack stack = player.getItemInHand(hand);
        int energyUsed = Oritech.CONFIG.portableLaserConfig.energyPerBoom();
        if (world.isClientSide) {
            if (this.getStoredEnergy(stack) > (long)energyUsed && !player.isShiftKeyDown() && !this.isMiningEnabled(stack)) {
                lastSingleShot = world.getGameTime();
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        Item item = stack.getItem();
        if (!(item instanceof PortableLaserItem)) {
            return InteractionResultHolder.consume((Object)stack);
        }
        PortableLaserItem laserItem = (PortableLaserItem)item;
        if (player.isShiftKeyDown()) {
            boolean lastMode = this.isMiningEnabled(stack);
            this.setMiningEnabled(stack, !lastMode);
            player.sendSystemMessage((Component)Component.translatable((String)"tooltip.oritech.portable_laser.status.begin").append((Component)Component.literal((String)String.valueOf(!lastMode))));
            return InteractionResultHolder.consume((Object)stack);
        }
        if (this.isMiningEnabled(stack)) {
            player.sendSystemMessage((Component)Component.translatable((String)"tooltip.oritech.portable_laser.status.shot_mining_error"));
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!laserItem.tryUseEnergy(stack, energyUsed, player)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.getCooldowns().addCooldown((Item)this, 24);
        HitResult hit = PortableLaserItem.getPlayerTargetRay(player);
        if (hit != null) {
            boolean canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean bl = canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction((Entity)player, hand, BlockPos.containing((Position)hit.getLocation()), Protection.EDIT_AND_INTERACT_BLOCK, null);
            }
            if (canInteract) {
                world.explode(null, new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.LIGHTNING_BOLT), (Entity)player), null, hit.getLocation(), (float)Oritech.CONFIG.portableLaserConfig.explosionStrength(), false, Level.ExplosionInteraction.MOB);
            }
            endPos = hit.getLocation();
        } else {
            Vec3 startPos = player.getEyePosition();
            Vec3 lookVec = player.getViewVector(0.0f);
            endPos = startPos.add(lookVec.scale(128.0));
        }
        if (hit instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hit).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean bl = canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction((Entity)player, hand, BlockPos.containing((Position)hit.getLocation()), Protection.INTERACT_ENTITY, (Entity)livingEntity);
            }
            if (canInteract) {
                PortableLaserItem.processEntityTarget(player, livingEntity, 20, stack, world);
            }
        }
        this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "laser", "singleshot");
        world.playSound(null, player.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 0.8f, 1.0f);
        float yawRadians = (player.getYRot() + 90.0f) * (float)Math.PI / 180.0f;
        double rightX = -Mth.sin((float)yawRadians);
        double rightZ = Mth.cos((float)yawRadians);
        Vec3 rightDir = new Vec3(rightX, 0.0, rightZ).normalize();
        Vec3 startPos = player.getEyePosition().add(endPos.subtract(player.getEyePosition()).scale((double)0.4f)).add(0.0, -0.5, 0.0).add(rightDir.scale((double)0.3f));
        ParticleContent.LASER_BOOM.spawn(world, startPos, (Object)endPos);
        ParticleContent.MELTDOWN_IMMINENT.spawn(world, endPos, (Object)6);
        return InteractionResultHolder.consume((Object)stack);
    }

    /*
     * Unable to fully structure code
     */
    public static void onUseTick(Player player) {
        block16: {
            block15: {
                world = player.level();
                stack = player.getItemInHand(InteractionHand.MAIN_HAND);
                var4_3 = stack.getItem();
                if (!(var4_3 instanceof PortableLaserItem)) break block15;
                laserItem = (PortableLaserItem)var4_3;
                if (world != null) break block16;
            }
            return;
        }
        rfUsage = Oritech.CONFIG.portableLaserConfig.energyPerTick();
        if (!laserItem.tryUseEnergy(stack, rfUsage, player)) {
            return;
        }
        finalHit = PortableLaserItem.getPlayerTargetRay(player);
        laserItem.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "laser", "shooting");
        if (!(finalHit instanceof BlockHitResult)) ** GOTO lbl-1000
        blockHitResult = (BlockHitResult)finalHit;
        if (laserItem.isMiningEnabled(stack)) {
            blockPos = blockHitResult.getBlockPos();
            blockState = world.getBlockState(blockPos);
            if (blockState.isAir() || blockState.is(TagContent.LASER_PASSTHROUGH)) {
                return;
            }
            canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                v0 = canInteract = FTBChunksAPI.api().getManager().shouldPreventInteraction((Entity)player, InteractionHand.MAIN_HAND, BlockPos.containing((Position)finalHit.getLocation()), Protection.EDIT_AND_INTERACT_BLOCK, null) == false;
            }
            if (canInteract) {
                PortableLaserItem.processBlockBreaking(blockPos, blockState, world, player, stack, rfUsage);
            }
        } else if (finalHit instanceof EntityHitResult) {
            entityHitResult = (EntityHitResult)finalHit;
            target = entityHitResult.getEntity();
            if (!(target instanceof LivingEntity)) {
                return;
            }
            livingEntity = (LivingEntity)target;
            canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                v1 = canInteract = FTBChunksAPI.api().getManager().shouldPreventInteraction((Entity)player, InteractionHand.MAIN_HAND, BlockPos.containing((Position)finalHit.getLocation()), Protection.EDIT_AND_INTERACT_BLOCK, target) == false;
            }
            if (canInteract) {
                PortableLaserItem.processEntityTarget(player, livingEntity, Oritech.CONFIG.portableLaserConfig.damageBase(), stack, world);
            }
        }
        if (finalHit != null && finalHit.getType() != HitResult.Type.MISS && laserItem.isMiningEnabled(stack)) {
            ParticleContent.LASER_BEAM_EFFECT.spawn(world, finalHit.getLocation());
        }
    }

    @Nullable
    public static HitResult getPlayerTargetRay(Player player) {
        double entityDistance;
        HitResult blockHit = player.pick(128.0, 0.0f, true);
        Vec3 startPos = player.getEyePosition();
        Vec3 lookVec = player.getViewVector(0.0f);
        Vec3 endPos = startPos.add(lookVec.scale(128.0));
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)startPos, (Vec3)endPos, (AABB)new AABB(startPos, endPos), entity -> !entity.isSpectator() && entity.isAttackable() && entity.isAlive() && entity != player, (double)16384.0);
        HitResult finalHit = null;
        double blockDistance = blockHit.getType() == HitResult.Type.BLOCK ? startPos.distanceToSqr(blockHit.getLocation()) : Double.MAX_VALUE;
        double d = entityDistance = entityHit != null ? startPos.distanceToSqr(entityHit.getLocation()) : Double.MAX_VALUE;
        if (blockDistance < entityDistance) {
            finalHit = blockHit;
        } else if (entityHit != null) {
            finalHit = entityHit;
        }
        return finalHit;
    }

    private static void processBlockBreaking(BlockPos blockPos, BlockState blockState, Level world, Player player, ItemStack tool, int energyUsed) {
        MachineCoreEntity coreBlock;
        BlockEntity blockEntity;
        if (blockState.getDestroySpeed((BlockGetter)world, blockPos) < 0.0f) {
            return;
        }
        Tuple stats = blockBreakStats.getOrDefault(player, (Tuple<BlockPos, Integer>)new Tuple((Object)BlockPos.ZERO, (Object)0));
        stats = !blockPos.equals(stats.getA()) ? new Tuple((Object)blockPos, (Object)energyUsed) : new Tuple((Object)blockPos, (Object)((Integer)stats.getB() + energyUsed));
        if (blockState.is(TagContent.LASER_ACCELERATED)) {
            blockState.randomTick((ServerLevel)world, blockPos, world.random);
            ParticleContent.ACCELERATING.spawn(world, Vec3.atLowerCornerOf((Vec3i)blockPos));
            stats = new Tuple((Object)blockPos, (Object)-1);
        }
        if ((blockEntity = world.getBlockEntity(blockPos)) instanceof MachineCoreEntity && (coreBlock = (MachineCoreEntity)blockEntity).isEnabled()) {
            blockEntity = (BlockEntity)coreBlock.getCachedController();
        }
        if (blockEntity != null) {
            EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, null, null);
            if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
                EnergyApi.BlockProvider provider = (EnergyApi.BlockProvider)blockEntity;
                storageCandidate = provider.getEnergyStorage(null);
            }
            if (storageCandidate instanceof DynamicEnergyStorage) {
                DynamicEnergyStorage dynamicStorage = (DynamicEnergyStorage)storageCandidate;
                long inserted = dynamicStorage.insertIgnoringLimit(energyUsed, false);
                if (inserted > 0L) {
                    dynamicStorage.update();
                }
                return;
            }
            if (storageCandidate != null) {
                long inserted = storageCandidate.insert(energyUsed, false);
                if (inserted > 0L) {
                    storageCandidate.update();
                }
                return;
            }
        }
        Integer currentInvestedEnergy = (Integer)stats.getB();
        int requiredBreakingEnergy = (int)(Math.sqrt(blockState.getDestroySpeed((BlockGetter)world, blockPos)) * (double)LaserArmBlockEntity.BLOCK_BREAK_ENERGY / (double)Oritech.CONFIG.portableLaserConfig.blockBreakSpeed());
        int efficiencyLevel = PortableLaserItem.getEnchantmentLevel(tool, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        if (efficiencyLevel > 0) {
            requiredBreakingEnergy /= efficiencyLevel + 1;
        }
        float currentProgress = (float)currentInvestedEnergy.intValue() / (float)requiredBreakingEnergy;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.destroyBlockProgress(0, blockPos, (int)(currentProgress * 10.0f));
        }
        if (currentInvestedEnergy > requiredBreakingEnergy) {
            stats = new Tuple((Object)blockPos, (Object)0);
            PortableLaserItem.finishBlockBreaking(blockPos, blockState, world, player, tool);
        }
        blockBreakStats.put(player, (Tuple<BlockPos, Integer>)stats);
    }

    private static void finishBlockBreaking(BlockPos targetPos, BlockState targetBlockState, Level world, Player player, ItemStack tool) {
        BlockEntity targetEntity = world.getBlockEntity(targetPos);
        List<ItemStack> dropped = Block.getDrops((BlockState)targetBlockState, (ServerLevel)((ServerLevel)world), (BlockPos)targetPos, (BlockEntity)targetEntity, (Entity)player, (ItemStack)tool);
        RecipeHolder<OritechRecipe> blockRecipe = LaserArmBlockEntity.tryGetRecipeOfBlock(targetBlockState, world);
        if (blockRecipe != null) {
            OritechRecipe recipe = (OritechRecipe)blockRecipe.value();
            int farmedCount = 1;
            dropped = List.of(new ItemStack((ItemLike)recipe.getResults().get(0).getItem(), farmedCount));
            ParticleContent.CHARGING.spawn(world, Vec3.atLowerCornerOf((Vec3i)targetPos), (Object)1);
        }
        for (ItemStack stack : dropped) {
            if (player.getInventory().add(stack)) continue;
            world.addFreshEntity((Entity)new ItemEntity(world, targetPos.getCenter().x, targetPos.getCenter().y, targetPos.getCenter().z, stack));
        }
        try {
            targetBlockState.getBlock().playerWillDestroy(world, targetPos, targetBlockState, player);
        }
        catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + String.valueOf(targetBlockState) + " at " + String.valueOf(targetPos) + ": " + exception.getLocalizedMessage());
        }
        world.addDestroyBlockEffect(targetPos, world.getBlockState(targetPos));
        world.playSound(null, targetPos, targetBlockState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        world.destroyBlock(targetPos, false);
    }

    private static void processEntityTarget(Player player, LivingEntity target, int damage, ItemStack tool, Level world) {
        if (target.getType().equals(EntityType.CREEPER) && !((Boolean)target.getEntityData().get(Creeper.DATA_IS_POWERED)).booleanValue()) {
            target.getEntityData().set(Creeper.DATA_IS_POWERED, (Object)true);
            return;
        }
        int sharpnessLevel = PortableLaserItem.getEnchantmentLevel(tool, (ResourceKey<Enchantment>)Enchantments.SHARPNESS);
        damage = (int)((double)damage * Math.sqrt(sharpnessLevel + 1));
        target.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.LIGHTNING_BOLT), (Entity)player), (float)damage);
    }

    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> enchantment) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Holder entry : enchantments.keySet()) {
            if (!entry.unwrapKey().isPresent() || !((ResourceKey)entry.unwrapKey().get()).equals(enchantment)) continue;
            return enchantments.getLevel(entry);
        }
        return 0;
    }

    public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(Player player, ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        String storedEnergy = TooltipHelper.getEnergyText(this.getStoredEnergy(stack));
        String capacity = TooltipHelper.getEnergyText(this.getEnergyCapacity(stack));
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{storedEnergy, capacity});
        tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        MutableComponent miningText = Component.translatable((String)"tooltip.oritech.portable_laser.status.begin").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(this.isMiningEnabled(stack))).withStyle(ChatFormatting.GOLD)).append((Component)Component.translatable((String)"tooltip.oritech.portable_laser.status.hint").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)miningText);
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            for (int i = 1; i <= 5; ++i) {
                tooltip.add((Component)Component.translatable((String)("tooltip.oritech.portable_laser." + i)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    public boolean isMiningEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ComponentContent.IS_AOE_ACTIVE.get(), (Object)false);
    }

    public void setMiningEnabled(ItemStack stack, boolean status) {
        stack.set(ComponentContent.IS_AOE_ACTIVE.get(), (Object)status);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80L;
    }

    @Override
    public long getEnergyMaxOutput(ItemStack stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80L;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "laser", 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                return state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("idle", IDLE).triggerableAnim("singleshot", SINGLE_SHOT).triggerableAnim("shooting", SHOOTING).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PortableLaserRenderer renderer;

            @NotNull
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PortableLaserRenderer("portable_laser");
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void receiveUsePacket(LaserPlayerUsePacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        PortableLaserItem.onUseTick(player);
    }

    public record LaserPlayerUsePacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LaserPlayerUsePacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("laser_use"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

