/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.init.FluidContent;
import rearth.oritech.item.tools.util.ArmorEventHandler;
import rearth.oritech.neoforge.NeoforgeEnergyApiImpl;
import rearth.oritech.neoforge.NeoforgeFluidApiImpl;
import rearth.oritech.neoforge.NeoforgeItemApiImpl;
import rearth.oritech.neoforge.OritechPlatformNeoForge;

@Mod(value="oritech")
public final class OritechModNeoForge {
    public OritechModNeoForge(IEventBus eventBus) {
        eventBus.register((Object)new EventHandler(this));
        EventHandler.COMPONENT_REGISTRAR.register(eventBus);
        OritechPlatformNeoForge.ATTACHMENT_TYPES.register(eventBus);
        NetworkManager.FLUID_STACK_CODEC = net.neoforged.neoforge.fluids.FluidStack.OPTIONAL_CODEC.xmap(FluidStackHooksForge::fromForge, FluidStackHooksForge::toForge);
        NetworkManager.FLUID_STACK_STREAM_CODEC = net.neoforged.neoforge.fluids.FluidStack.OPTIONAL_STREAM_CODEC.map(FluidStackHooksForge::fromForge, FluidStackHooksForge::toForge);
        Oritech.initialize();
    }

    class EventHandler {
        public static final DeferredRegister.DataComponents COMPONENT_REGISTRAR = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"oritech");
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> IS_AOE_ACTIVE = COMPONENT_REGISTRAR.registerComponentType("is_aoe_active", builder -> builder.persistent((Codec)PrimitiveCodec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> TARGET_POSITION = COMPONENT_REGISTRAR.registerComponentType("target_position", builder -> builder.persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC));
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<FluidStack>> STORED_FLUID = COMPONENT_REGISTRAR.registerComponentType("stored_fluid", builder -> builder.persistent(FluidStack.CODEC).networkSynchronized(FluidStack.STREAM_CODEC));
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<Long>> NEO_ENERGY_COMPONENT = COMPONENT_REGISTRAR.registerComponentType("energy", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));

        EventHandler(OritechModNeoForge this$0) {
        }

        @SubscribeEvent
        public void registerCapabilities(RegisterCapabilitiesEvent event) {
            Object neoApi;
            Object object = ItemApi.BLOCK;
            if (object instanceof NeoforgeItemApiImpl) {
                neoApi = (NeoforgeItemApiImpl)object;
                ((NeoforgeItemApiImpl)neoApi).registerEvent(event);
            }
            if ((object = FluidApi.ITEM) instanceof NeoforgeFluidApiImpl) {
                neoApi = (NeoforgeFluidApiImpl)object;
                ((NeoforgeFluidApiImpl)neoApi).registerEvent(event);
            }
            if ((object = FluidApi.BLOCK) instanceof NeoforgeFluidApiImpl) {
                neoApi = (NeoforgeFluidApiImpl)object;
                ((NeoforgeFluidApiImpl)neoApi).registerEvent(event);
            }
            if ((object = EnergyApi.ITEM) instanceof NeoforgeEnergyApiImpl) {
                neoApi = (NeoforgeEnergyApiImpl)object;
                ((NeoforgeEnergyApiImpl)neoApi).registerEvent(event);
            }
            if ((object = EnergyApi.BLOCK) instanceof NeoforgeEnergyApiImpl) {
                neoApi = (NeoforgeEnergyApiImpl)object;
                ((NeoforgeEnergyApiImpl)neoApi).registerEvent(event);
            }
        }

        @SubscribeEvent
        public void register(RegisterEvent event) {
            ResourceLocation id = event.getRegistryKey().location();
            if (Oritech.EVENT_MAP.containsKey((Object)id)) {
                Oritech.LOGGER.debug(event.getRegistryKey().toString());
                Oritech.EVENT_MAP.get((Object)id).forEach(Runnable::run);
            }
            if (event.getRegistryKey().equals(NeoForgeRegistries.Keys.FLUID_TYPES)) {
                FluidContent.FLUID_ATTRIBUTES.forEach(attribute -> {
                    FluidType type = attribute.getSourceFluid().getFluidType();
                    ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)attribute.getSourceFluid());
                    event.register(NeoForgeRegistries.Keys.FLUID_TYPES, registry -> registry.register(fluidId, (Object)type));
                });
            }
        }

        @SubscribeEvent
        public void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (Consumer consumer : OritechPlatformNeoForge.PENDING_S2C_INITS) {
                consumer.accept(registrar);
            }
            OritechPlatformNeoForge.PENDING_S2C_INITS.clear();
            for (Consumer consumer : OritechPlatformNeoForge.PENDING_C2S_INITS) {
                consumer.accept(registrar);
            }
            OritechPlatformNeoForge.PENDING_C2S_INITS.clear();
        }
    }

    @EventBusSubscriber(modid="oritech")
    static class CustomEvents {
        CustomEvents() {
        }

        @SubscribeEvent
        public static void onEquipmentChanged(LivingEquipmentChangeEvent event) {
            ArmorEventHandler.processEvent(event.getEntity(), event.getSlot(), event.getFrom(), event.getTo());
        }
    }
}

