/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public record FluidIngredient(Either<TagKey<Fluid>, ResourceLocation> fluidContent, long amount) implements Predicate<FluidStack>
{
    public static final Endec<FluidIngredient> FLUID_INGREDIENT_ENDEC = StructEndecBuilder.of((StructField)CodecUtils.eitherEndec((Endec)Endec.STRING.xmap(s -> {
        if (s.charAt(0) != '#') {
            throw new IllegalStateException("tag must start with #");
        }
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)s.substring(1)));
    }, tag -> "#" + String.valueOf(tag.location())), (Endec)MinecraftEndecs.IDENTIFIER).fieldOf("fluid", FluidIngredient::fluidContent), (StructField)Endec.LONG.optionalFieldOf("amount", FluidIngredient::amount, (Object)FluidStack.bucketAmount()), FluidIngredient::new);
    public static final StreamCodec<ByteBuf, TagKey<Fluid>> FLUID_TAG_KEY_CODEC = ResourceLocation.STREAM_CODEC.map(id -> TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id), TagKey::location);
    public static final StreamCodec<RegistryFriendlyByteBuf, Either<TagKey<Fluid>, ResourceLocation>> FLUID_CONTENT_CODEC = ByteBufCodecs.either(FLUID_TAG_KEY_CODEC, (StreamCodec)ResourceLocation.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredient> PACKET_CODEC = StreamCodec.composite(FLUID_CONTENT_CODEC, FluidIngredient::fluidContent, (StreamCodec)ByteBufCodecs.VAR_LONG, FluidIngredient::amount, FluidIngredient::new);
    public static final FluidIngredient EMPTY = new FluidIngredient();

    public FluidIngredient() {
        this((Either<TagKey<Fluid>, ResourceLocation>)Either.right((Object)BuiltInRegistries.FLUID.getKey((Object)Fluids.EMPTY)), 0L);
    }

    public FluidIngredient withContent(ResourceLocation fluidId) {
        return new FluidIngredient((Either<TagKey<Fluid>, ResourceLocation>)Either.right((Object)fluidId), this.amount == 0L && BuiltInRegistries.FLUID.get(fluidId) != Fluids.EMPTY ? FluidStack.bucketAmount() : this.amount);
    }

    public FluidIngredient withContent(ResourceKey<Fluid> fluidKey) {
        return this.withContent(fluidKey.location());
    }

    public FluidIngredient withContent(Fluid fluid) {
        return this.withContent(BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    public FluidIngredient withContent(TagKey<Fluid> fluidTag) {
        return new FluidIngredient((Either<TagKey<Fluid>, ResourceLocation>)Either.left(fluidTag), this.amount == 0L ? FluidStack.bucketAmount() : this.amount);
    }

    public FluidIngredient withAmount(long withAmount) {
        return new FluidIngredient(this.fluidContent, withAmount);
    }

    public FluidIngredient withAmount(float withAmountInBuckets) {
        return new FluidIngredient(this.fluidContent, (long)(withAmountInBuckets * (float)FluidStack.bucketAmount()));
    }

    public FluidIngredient withSpecificAmount(long amountInMillis) {
        return new FluidIngredient(this.fluidContent, amountInMillis);
    }

    public static FluidIngredient ofStack(FluidStack fluidStack) {
        return new FluidIngredient((Either<TagKey<Fluid>, ResourceLocation>)Either.right((Object)BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid())), fluidStack.getAmount());
    }

    public Component name() {
        ResourceLocation fluidId = (ResourceLocation)this.fluidContent.map(tag -> tag.location(), id -> id);
        return this.hasTag() ? Component.nullToEmpty((String)("#" + fluidId.getNamespace() + ":" + fluidId.getPath())) : Component.translatable((String)("fluid." + ((ResourceLocation)this.fluidContent.map(tag -> tag.location(), id -> id)).toLanguageKey()));
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.matchesFluid(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean matchesFluid(Fluid fluid) {
        ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)""))).isSame(fluid);
        return (Boolean)this.fluidContent.map(tag -> BuiltInRegistries.FLUID.wrapAsHolder((Object)fluid).is(tag), id -> ((Fluid)BuiltInRegistries.FLUID.get(id)).isSame(fluid));
    }

    public boolean matchesFluid(@Nullable FluidStack fluidStack) {
        return fluidStack != null && this.matchesFluid(fluidStack.getFluid());
    }

    public List<FluidStack> getFluidStacks() {
        return (List)this.fluidContent.map(tag -> BuiltInRegistries.FLUID.holders().filter(fluidEntry -> fluidEntry.is(tag)).map(fluidEntry -> FluidStack.create((Fluid)((Fluid)fluidEntry.value()), (long)this.amount)).collect(Collectors.toList()), id -> List.of(FluidStack.create((Fluid)((Fluid)BuiltInRegistries.FLUID.get((ResourceLocation)this.fluidContent.right().get())), (long)this.amount)));
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean hasTag() {
        return this.fluidContent.left().isPresent();
    }

    public TagKey<Fluid> getTag() {
        return (TagKey)this.fluidContent.left().get();
    }

    public Fluid getFluid() {
        return (Fluid)BuiltInRegistries.FLUID.get((ResourceLocation)this.fluidContent.right().get());
    }

    @Override
    public String toString() {
        return "FluidIngredient{fluidContent={tag=" + String.valueOf(this.fluidContent.left()) + ", id=" + String.valueOf(this.fluidContent.right()) + "}, amount=" + this.amount + "}";
    }
}

