/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.block.entity.storage.SmallTankEntity;
import rearth.oritech.init.LootContent;

public class NbtBlockLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "nbt_block_loot";
    public static final MapCodec<NbtBlockLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootItemConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, NbtBlockLootFunction::new));

    public NbtBlockLootFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof SmallTankEntity) {
            SmallTankEntity tankEntity = (SmallTankEntity)blockEntity;
            if (tankEntity.fluidStorage.getAmount() > 0L) {
                stack.set(FluidApi.ITEM.getFluidComponent(), (Object)tankEntity.fluidStorage.getStack());
                return stack;
            }
        }
        if (!(blockEntity instanceof SmallStorageBlockEntity)) return stack;
        SmallStorageBlockEntity storageEntity = (SmallStorageBlockEntity)blockEntity;
        if (storageEntity.energyStorage.amount <= 0L) return stack;
        stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)storageEntity.energyStorage.amount);
        return stack;
    }

    public LootItemFunctionType<NbtBlockLootFunction> getType() {
        return LootContent.NBT_BLOCK_LOOT_FUNCTION;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(NbtBlockLootFunction::new);
    }
}

