/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.owo.registration.reflect.BlockRegistryContainer;
import java.lang.reflect.Field;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import rearth.oritech.util.registry.ArchitecturyRegistryContainer;

public interface ArchitecturyBlockRegistryContainer
extends ArchitecturyRegistryContainer<Block> {
    public static final DeferredRegister<Item> ITEM_REGISTRY = DeferredRegister.create((String)"oritech", (ResourceKey)Registries.ITEM);

    @Override
    default public ResourceKey<Registry<Block>> getRegistryType() {
        return Registries.BLOCK;
    }

    default public Class<Block> getTargetFieldType() {
        return Block.class;
    }

    @Override
    default public void postProcessField(String namespace, Block value, String identifier, Field field, RegistrySupplier<Block> supplier) {
        if (field.isAnnotationPresent(BlockRegistryContainer.NoBlockItem.class)) {
            return;
        }
        ITEM_REGISTRY.register(identifier, () -> this.createBlockItem(value, identifier));
    }

    default public BlockItem createBlockItem(Block block, String identifier) {
        return new BlockItem(block, new Item.Properties());
    }

    public static void finishItemRegister() {
        ITEM_REGISTRY.register();
    }
}

