/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.interaction;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.behavior.LaserArmBlockBehavior;
import rearth.oritech.block.behavior.LaserArmEntityBehavior;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class LaserArmBlock
extends class_2248
implements class_2343 {
    private static final LaserArmBlockBehavior DEFAULT_BLOCK_BEHAVIOR = new LaserArmBlockBehavior();
    public static final Map<class_2248, LaserArmBlockBehavior> BLOCK_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final LaserArmEntityBehavior DEFAULT_ENTITY_BEHAVIOR = new LaserArmEntityBehavior();
    public static final Map<class_1299<?>, LaserArmEntityBehavior> ENTITY_BEHAVIORS = new Object2ObjectOpenHashMap();

    public LaserArmBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036));
        LaserArmBlockBehavior.registerDefaults();
        LaserArmEntityBehavior.registerDefaults();
    }

    public static void registerBlockBehavior(class_2248 targetBlock, LaserArmBlockBehavior behavior) {
        BLOCK_BEHAVIORS.put(targetBlock, behavior);
    }

    public static void registerEntityBehavior(class_1299<?> entityType, LaserArmEntityBehavior behavior) {
        ENTITY_BEHAVIORS.put(entityType, behavior);
    }

    public static LaserArmBlockBehavior getBehaviorForBlock(class_2248 targetBlock) {
        return BLOCK_BEHAVIORS.getOrDefault(targetBlock, DEFAULT_BLOCK_BEHAVIOR);
    }

    public static LaserArmEntityBehavior getBehaviorForEntity(class_1299<?> targetEntityType) {
        return ENTITY_BEHAVIORS.getOrDefault(targetEntityType, DEFAULT_ENTITY_BEHAVIOR);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)class_2741.field_12525, (Comparable)ctx.method_8038());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{MultiblockMachine.ASSEMBLED});
        builder.method_11667(new class_2769[]{class_2741.field_12525});
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.field_9236) {
            return;
        }
        boolean isPowered = world.method_49803(pos);
        LaserArmBlockEntity laserEntity = (LaserArmBlockEntity)world.method_8321(pos);
        laserEntity.setRedstonePowered(isPowered);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            Boolean corePlaced;
            class_2586 entity = world.method_8321(pos);
            if (!(entity instanceof LaserArmBlockEntity)) {
                return class_1269.field_5812;
            }
            LaserArmBlockEntity laserArm = (LaserArmBlockEntity)entity;
            Boolean wasAssembled = (Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = laserArm.tryPlaceNextCore(player)).booleanValue()) {
                return class_1269.field_5812;
            }
            boolean isAssembled = laserArm.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                laserArm.triggerSetupAnimation();
                laserArm.initAddons();
                return class_1269.field_5812;
            }
            if (!isAssembled) {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            laserArm.initAddons();
            MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)laserArm);
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608()) {
            Object machineEntity;
            class_2586 entity = world.method_8321(pos);
            if (((Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue() && entity instanceof MultiblockMachineController) {
                machineEntity = (MultiblockMachineController)entity;
                machineEntity.onControllerBroken();
            }
            if (entity instanceof MachineAddonController) {
                machineEntity = (MachineAddonController)entity;
                machineEntity.resetAddons();
            }
            if (entity instanceof LaserArmBlockEntity) {
                LaserArmBlockEntity storageBlock = (LaserArmBlockEntity)entity;
                class_2371<class_1799> stacks = storageBlock.inventory.heldStacks;
                for (class_1799 heldStack : stacks) {
                    if (heldStack.method_7960()) continue;
                    class_1542 itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), heldStack);
                    world.method_8649((class_1297)itemEntity);
                }
                storageBlock.inventory.heldStacks.clear();
                storageBlock.inventory.method_5431();
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LaserArmBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558) {
                class_5558 ticker = (class_5558)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
    }
}

