/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MultiblockMachineController;

public class MachineCoreEntity
extends class_2586
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
FluidApi.BlockProvider {
    private class_2338 controllerPos = class_2338.field_10980;
    private MultiblockMachineController controllerEntity;
    private final Map<class_2350, DelegatingEnergyStorage> delegatedEnergy = new HashMap<class_2350, DelegatingEnergyStorage>(6);
    private final Map<class_2350, DelegatingFluidStorage> delegatedFluid = new HashMap<class_2350, DelegatingFluidStorage>(6);
    private final Map<class_2350, DelegatingInventoryStorage> delegatedItem = new HashMap<class_2350, DelegatingInventoryStorage>(6);

    public MachineCoreEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.MACHINE_CORE_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("controller_x", this.controllerPos.method_10263());
        nbt.method_10569("controller_y", this.controllerPos.method_10264());
        nbt.method_10569("controller_z", this.controllerPos.method_10260());
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.controllerPos = new class_2338(nbt.method_10550("controller_x"), nbt.method_10550("controller_y"), nbt.method_10550("controller_z"));
    }

    public class_2338 getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(class_2338 controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerEntity = null;
        this.method_5431();
    }

    @Nullable
    public MultiblockMachineController getCachedController() {
        if (this.field_11863 == null || !((Boolean)this.method_11010().method_11654((class_2769)MachineCoreBlock.USED)).booleanValue()) {
            return null;
        }
        if (this.controllerEntity == null || ((class_2586)this.controllerEntity).method_11015()) {
            MultiblockMachineController controller;
            class_2586 candidate = Objects.requireNonNull(this.field_11863).method_8321(this.getControllerPos());
            this.controllerEntity = candidate instanceof MultiblockMachineController ? (controller = (MultiblockMachineController)candidate) : null;
        }
        return this.controllerEntity;
    }

    @Nullable
    private EnergyApi.EnergyStorage getMainEnergyStorage(class_2350 direction) {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (controllerEntity == null) {
            return new SimpleEnergyStorage(0L, 0L, 0L);
        }
        return controllerEntity.getEnergyStorageForMultiblock(direction);
    }

    private FluidApi.FluidStorage getMainFluidStorage(class_2350 direction) {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof FluidApi.BlockProvider)) {
            return null;
        }
        FluidApi.BlockProvider fluidProvider = (FluidApi.BlockProvider)((Object)controllerEntity);
        return fluidProvider.getFluidStorage(direction);
    }

    private ItemApi.InventoryStorage getMainItemStorage(class_2350 direction) {
        Boolean isUsed = (Boolean)this.method_11010().method_11654((class_2769)MachineCoreBlock.USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MultiblockMachineController controllerEntity = this.getCachedController();
        if (!(controllerEntity instanceof ItemApi.BlockProvider)) {
            return null;
        }
        ItemApi.BlockProvider itemProvider = (ItemApi.BlockProvider)((Object)controllerEntity);
        return itemProvider.getInventoryStorage(direction);
    }

    @Nullable
    private EnergyApi.EnergyStorage getEnergyStorageDelegated(class_2350 direction) {
        return this.delegatedEnergy.computeIfAbsent(direction, dir -> {
            if (this.getMainEnergyStorage((class_2350)dir) == null) {
                return null;
            }
            return new DelegatingEnergyStorage(() -> this.getMainEnergyStorage((class_2350)dir), this::isEnabled);
        });
    }

    private FluidApi.FluidStorage getFluidStorageDelegated(class_2350 direction) {
        return this.delegatedFluid.computeIfAbsent(direction, dir -> {
            if (this.getMainFluidStorage((class_2350)dir) == null) {
                return null;
            }
            return new DelegatingFluidStorage(() -> this.getMainFluidStorage((class_2350)dir), this::isEnabled);
        });
    }

    private ItemApi.InventoryStorage getItemStorageDelegated(class_2350 direction) {
        return this.delegatedItem.computeIfAbsent(direction, dir -> {
            if (this.getMainItemStorage((class_2350)dir) == null) {
                return null;
            }
            return new DelegatingInventoryStorage(() -> this.getMainItemStorage((class_2350)dir), this::isEnabled);
        });
    }

    public void resetCaches() {
        this.delegatedItem.clear();
        this.delegatedFluid.clear();
        this.delegatedEnergy.clear();
    }

    public boolean isEnabled() {
        return (Boolean)this.method_11010().method_11654((class_2769)MachineCoreBlock.USED);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.getEnergyStorageDelegated(direction);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.getItemStorageDelegated(direction);
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        return this.getFluidStorageDelegated(direction);
    }
}

