/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.armor;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.item.tools.armor.JetpackItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.TooltipHelper;

public interface BaseJetpackItem
extends OritechEnergyItem,
FluidApi.ItemProvider {
    public boolean requireUpward();

    public int getRfUsage();

    public int getFuelUsage();

    public long getFuelCapacity();

    public float getSpeed();

    default public boolean requireTakeoff() {
        return true;
    }

    default public void tickJetpack(class_1799 stack, class_1297 entity, class_1937 world) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        boolean isEquipped = player.method_6118(class_1304.field_6174).equals(stack);
        if (!isEquipped) {
            return;
        }
        class_310 client = class_310.method_1551();
        boolean up = client.field_1690.field_1903.method_1434();
        boolean forward = client.field_1690.field_1894.method_1434();
        boolean backward = client.field_1690.field_1881.method_1434();
        boolean left = client.field_1690.field_1913.method_1434();
        boolean right = client.field_1690.field_1849.method_1434();
        boolean horizontal = forward || backward || left || right;
        boolean upOnly = up && !horizontal;
        boolean isActive = up;
        if (!this.requireUpward()) {
            boolean bl = isActive = up || horizontal;
        }
        if (this.requireTakeoff() && !BaseJetpackItem.isJetpackStarted(player, world, up)) {
            return;
        }
        if (!isActive || player.method_24828() || player.method_5869()) {
            return;
        }
        float powerMultiplier = this.getSpeed();
        if (this.tryUseFluid(stack)) {
            powerMultiplier *= 2.5f;
        } else if (!this.tryUseEnergy(stack, this.getRfUsage(), player)) {
            return;
        }
        if (up) {
            BaseJetpackItem.processUpwardsMotion(player, powerMultiplier, upOnly);
        } else {
            powerMultiplier *= 0.7f;
        }
        if (forward || backward) {
            BaseJetpackItem.processForwardMotion(player, forward, powerMultiplier);
        }
        if (left || right) {
            BaseJetpackItem.processSideMotion(player, right, powerMultiplier);
        }
        FluidStack fluidStack = this.getStoredFluid(stack);
        class_2960 fluid = class_7923.field_41173.method_10221((Object)fluidStack.getFluid());
        NetworkManager.sendToServer(new JetpackItem.JetpackUsageUpdatePacket(this.getStoredEnergy(stack), fluid.toString(), fluidStack.getAmount()));
        class_243 playerForward = player.method_5663();
        class_243 playerRight = playerForward.method_1029().method_1024(-90.0f);
        class_243 particleCenter = player.method_33571().method_1031(0.0, -1.1, 0.0).method_1020(playerForward.method_1021((double)0.2f));
        class_243 particlePosA = particleCenter.method_1019(playerRight.method_1021((double)0.4f));
        class_243 particlePosB = particleCenter.method_1019(playerRight.method_1021((double)-0.4f));
        class_243 direction = new class_243(0.0, -1.0, 0.0);
        if (forward) {
            direction = playerForward.method_1029().method_1021(-1.0).method_1031(0.0, -1.0, 0.0);
        }
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosA, (Object)direction);
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosB, (Object)direction);
    }

    private static boolean isJetpackStarted(class_1657 player, class_1937 world, boolean up) {
        boolean grounded;
        boolean bl = grounded = player.method_24828() || player.method_5869();
        if (grounded) {
            JetpackItem.LAST_GROUND_CONTACT = world.method_8510();
            JetpackItem.PRESSED_SPACE = false;
            return false;
        }
        long flightTime = world.method_8510() - JetpackItem.LAST_GROUND_CONTACT;
        if (flightTime < 5L) {
            return false;
        }
        if (up) {
            JetpackItem.PRESSED_SPACE = true;
        }
        return JetpackItem.PRESSED_SPACE;
    }

    private static void processUpwardsMotion(class_1657 player, float powerMultiplier, boolean upOnly) {
        class_243 velocity = player.method_60478();
        double verticalMultiplier = LaserArmRenderer.lerp(powerMultiplier, 1.0, (double)0.6f);
        double power = (double)0.13f * verticalMultiplier;
        float dampeningFactor = 1.7f;
        if (!upOnly) {
            power *= (double)0.7f;
        }
        double speed = Math.max(velocity.field_1351, 0.8);
        double addedVelocity = power / Math.pow(speed, dampeningFactor);
        player.method_18799(velocity.method_1031(0.0, addedVelocity, 0.0));
    }

    private static void processSideMotion(class_1657 player, boolean right, float powerMultiplier) {
        int modifier = right ? 1 : -1;
        float power = 0.04f * powerMultiplier;
        class_243 movement = player.method_60478();
        class_243 horizontalMovement = new class_243(movement.field_1352, 0.0, movement.field_1350);
        class_243 playerForward = player.method_5663();
        playerForward = new class_243(playerForward.field_1352, 0.0, playerForward.field_1350).method_1029();
        class_243 playerRight = playerForward.method_1024(-90.0f);
        horizontalMovement = horizontalMovement.method_1019(playerRight.method_1021((double)((float)modifier * power)));
        player.method_18800(horizontalMovement.field_1352, movement.field_1351, horizontalMovement.field_1350);
    }

    private static void processForwardMotion(class_1657 player, boolean forward, float powerMultiplier) {
        double modifier = forward ? 1.0 : -0.4;
        float power = 0.06f * powerMultiplier;
        class_243 movement = player.method_60478();
        class_243 horizontalMovement = new class_243(movement.field_1352, 0.0, movement.field_1350);
        class_243 playerForward = player.method_5663();
        playerForward = new class_243(playerForward.field_1352, 0.0, playerForward.field_1350).method_1029();
        horizontalMovement = horizontalMovement.method_1019(playerForward.method_1021(modifier * (double)power));
        player.method_18800(horizontalMovement.field_1352, movement.field_1351, horizontalMovement.field_1350);
    }

    default public boolean tryUseFluid(class_1799 stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() < (long)this.getFuelUsage() || !this.isValidFuel(fluidStack.getFluid())) {
            return false;
        }
        FluidStack res = FluidStack.create((class_3611)fluidStack.getFluid(), (long)(fluidStack.getAmount() - (long)this.getFuelUsage()));
        stack.method_57379(ComponentContent.STORED_FLUID.get(), (Object)res);
        return true;
    }

    default public FluidStack getStoredFluid(class_1799 stack) {
        return (FluidStack)stack.method_57825(ComponentContent.STORED_FLUID.get(), (Object)FluidStack.empty());
    }

    default public void addJetpackTooltip(class_1799 stack, List<class_2561> tooltip, boolean includeEnergy) {
        class_5250 text = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack))});
        if (includeEnergy) {
            tooltip.add((class_2561)text.method_27692(class_124.field_1065));
        }
        FluidStack container = this.getStoredFluid(stack);
        class_5250 fluidText = class_2561.method_43469((String)"tooltip.oritech.jetpack_fuel", (Object[])new Object[]{container.getAmount() * 1000L / FluidStackHooks.bucketAmount(), this.getFuelCapacity() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)container).getString()});
        tooltip.add((class_2561)fluidText);
    }

    default public int getJetpackBarColor(class_1799 stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() > (long)this.getFuelUsage() && this.isValidFuel(fluidStack.getFluid())) {
            return 12254211;
        }
        return 0xFF7007;
    }

    default public int getJetpackBarStep(class_1799 stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() > (long)this.getFuelUsage() && this.isValidFuel(fluidStack.getFluid())) {
            long fillPercent = fluidStack.getAmount() * 100L / this.getFuelCapacity();
            return Math.round(fillPercent * 13L) / 100;
        }
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    default public boolean isValidFuel(class_3611 variant) {
        return variant.method_15780((class_3611)FluidContent.STILL_FUEL.get());
    }

    @Override
    default public FluidApi.SingleSlotStorage getFluidStorage(class_1799 stack) {
        return new SimpleItemFluidStorage(this.getFuelCapacity(), stack){

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                boolean valid = BaseJetpackItem.this.isValidFuel(toInsert.getFluid());
                if (!valid) {
                    return 0L;
                }
                return super.insert(toInsert, simulate);
            }
        };
    }
}

