/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class SimpleFluidStorage
extends FluidApi.SingleSlotStorage
implements UpdatableField<Void, FluidStack> {
    private FluidStack content;
    private final Long capacity;
    private final Runnable onUpdate;

    public static Long transfer(SimpleFluidStorage from, SimpleFluidStorage to, long maxAmount, boolean simulate) {
        long extracted = from.extract(FluidStack.create((class_3611)from.getFluid(), (long)maxAmount, (class_9326)from.getChanges()), true);
        long inserted = to.insert(FluidStack.create((class_3611)from.getFluid(), (long)extracted, (class_9326)from.getChanges()), simulate);
        extracted = from.extract(FluidStack.create((class_3611)from.getFluid(), (long)inserted, (class_9326)from.getChanges()), simulate);
        if (extracted > 0L && !simulate) {
            from.update();
            to.update();
        }
        return extracted;
    }

    public SimpleFluidStorage(Long capacity, Runnable onUpdate) {
        this.capacity = capacity;
        this.onUpdate = onUpdate;
        this.content = FluidStack.create((class_3611)this.getEmptyVariant(), (long)0L);
    }

    public class_3611 getEmptyVariant() {
        return class_3612.field_15906;
    }

    public SimpleFluidStorage(Long capacity) {
        this(capacity, () -> {});
    }

    @Override
    public long insert(FluidStack toInsert, boolean simulate) {
        return SimpleInOutFluidStorage.insertTo(toInsert, simulate, this.capacity, this.content, stack -> {
            this.content = stack;
        });
    }

    @Override
    public long extract(FluidStack toExtract, boolean simulate) {
        return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.content);
    }

    @Override
    public List<FluidStack> getContent() {
        return List.of(this.content);
    }

    public void writeNbt(class_2487 nbt, String suffix) {
        FluidStack.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.content).result().ifPresent(tag -> nbt.method_10566("fluid" + suffix, tag));
    }

    public void readNbt(class_2487 nbt, String suffix) {
        this.content = FluidStack.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("fluid" + suffix)).result().orElse(FluidStack.empty());
    }

    public void setAmount(long amount) {
        this.content.setAmount(amount);
    }

    public long getAmount() {
        return this.content.getAmount();
    }

    public void setFluid(class_3611 fluid) {
        this.content = FluidStack.create((class_3611)fluid, (long)this.getAmount(), (class_9326)this.getChanges());
    }

    public class_3611 getFluid() {
        return this.content.getFluid();
    }

    public void setChanges(class_9326 data) {
        this.content = FluidStack.create((class_3611)this.getFluid(), (long)this.getAmount(), (class_9326)data);
    }

    public class_9326 getChanges() {
        return this.content.getPatch();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public void setStack(FluidStack stack) {
        this.content = stack.copy();
    }

    @Override
    public FluidStack getStack() {
        return this.content;
    }

    @Override
    public FluidStack getDeltaData() {
        return this.content;
    }

    @Override
    public Void getFullData() {
        return null;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }

    @Override
    public class_9139<? extends ByteBuf, FluidStack> getDeltaCodec() {
        return NetworkManager.FLUID_STACK_STREAM_CODEC;
    }

    @Override
    public class_9139<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }

    @Override
    public void handleFullUpdate(Void updatedData) {
    }

    @Override
    public void handleDeltaUpdate(FluidStack updatedData) {
        this.setStack(updatedData);
    }
}

