/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_3545;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import rearth.oritech.api.networking.NetworkManager;

public class ReflectiveCodecBuilder {
    public static <E extends Enum<E>> class_9139<class_9129, E> createForEnum(final Class<E> enumClass) {
        return new class_9139<class_9129, E>(){

            public void encode(class_9129 buf, E value) {
                buf.method_52998(((Enum)value).ordinal());
            }

            public E decode(class_9129 buf) {
                short ordinal = buf.readShort();
                return ((Enum[])enumClass.getEnumConstants())[ordinal];
            }
        };
    }

    public static <T extends Record> class_9139<class_9129, T> create(final Class<T> recordClass) {
        MethodHandle constructorHandle;
        if (!recordClass.isRecord()) {
            throw new IllegalArgumentException(recordClass.getName() + " is not a record type.");
        }
        final RecordComponent[] recordComponents = recordClass.getRecordComponents();
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        final ArrayList<MethodHandle> accessors = new ArrayList<MethodHandle>(recordComponents.length);
        final ArrayList<class_9139> componentCodecs = new ArrayList<class_9139>(recordComponents.length);
        Class[] componentTypes = new Class[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            RecordComponent component = recordComponents[i];
            componentTypes[i] = component.getType();
            try {
                class_9139 codec;
                accessors.add(lookup.unreflect(component.getAccessor()));
                Optional<Type> listCandidate = NetworkManager.getListType(component.getGenericType());
                Optional<class_3545<Type, Type>> mapCandidate = NetworkManager.getMapType(component.getGenericType());
                if (listCandidate.isPresent()) {
                    codec = NetworkManager.getAutoCodec((Class)listCandidate.get()).method_56433(class_9135.method_56363());
                    if (codec == null) {
                        throw new RuntimeException("Failed to get codec for record component: " + component.getName() + " in " + recordClass.getName());
                    }
                    componentCodecs.add(codec);
                    continue;
                }
                if (mapCandidate.isPresent()) {
                    class_9139 keyCodec = NetworkManager.getAutoCodec((Class)mapCandidate.get().method_15442());
                    class_9139 valueCodec = NetworkManager.getAutoCodec((Class)mapCandidate.get().method_15441());
                    class_9139 codec2 = class_9135.method_56377(HashMap::new, (class_9139)keyCodec, (class_9139)valueCodec);
                    componentCodecs.add(codec2);
                    continue;
                }
                codec = NetworkManager.getAutoCodec(component.getType());
                if (codec == null) {
                    throw new RuntimeException("Failed to get codec for record component: " + component.getName() + " in " + recordClass.getName());
                }
                componentCodecs.add(codec);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to unreflect accessor for component: " + component.getName() + " in " + recordClass.getName(), e);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Failed to get codec for component: " + component.getName() + " in " + recordClass.getName(), e);
            }
        }
        try {
            Constructor<T> constructor = recordClass.getDeclaredConstructor(componentTypes);
            constructor.setAccessible(true);
            constructorHandle = lookup.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to find or unreflect canonical constructor for record: " + recordClass.getName(), e);
        }
        return new class_9139<class_9129, T>(){

            public T decode(class_9129 buffer) {
                Object[] constructorArgs = new Object[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    try {
                        constructorArgs[i] = ((class_9139)componentCodecs.get(i)).decode((Object)buffer);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error decoding component " + recordComponents[i].getName() + " for record " + recordClass.getName(), e);
                    }
                }
                try {
                    return (Record)constructorHandle.invokeWithArguments(constructorArgs);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Error constructing record " + recordClass.getName(), e);
                }
            }

            public void encode(class_9129 buffer, T recordInstance) {
                for (int i = 0; i < recordComponents.length; ++i) {
                    try {
                        Object value = ((MethodHandle)accessors.get(i)).invoke((Record)recordInstance);
                        class_9139 valueCodec = (class_9139)componentCodecs.get(i);
                        valueCodec.encode((Object)buffer, value);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error encoding component " + recordComponents[i].getName() + " of record " + recordClass.getName(), e);
                    }
                }
            }
        };
    }
}

