/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe;

import com.google.common.base.Optional;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_8790;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;

public abstract class OritechRecipeBuilder {
    protected final OritechRecipeType type;
    protected List<class_1856> inputs;
    protected List<class_1799> results;
    protected FluidIngredient fluidInput;
    protected List<FluidStack> fluidOutputs;
    protected int time = 200;
    protected float timeMultiplier = 1.0f;
    protected boolean addToGrinder;
    private final String resourcePath;

    protected OritechRecipeBuilder(OritechRecipeType type, String resourcePath) {
        this.type = type;
        this.resourcePath = resourcePath;
        this.fluidOutputs = new ArrayList<FluidStack>();
    }

    public OritechRecipeBuilder input(List<class_1856> in) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<class_1856>();
        }
        this.inputs.addAll(in);
        return this;
    }

    public OritechRecipeBuilder input(class_1856 in) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<class_1856>();
        }
        this.inputs.add(in);
        return this;
    }

    public OritechRecipeBuilder input(class_1935 in) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{in}));
    }

    public OritechRecipeBuilder input(class_6862<class_1792> in) {
        return this.input(class_1856.method_8106(in));
    }

    public OritechRecipeBuilder fluidInput(FluidIngredient in) {
        this.fluidInput = in;
        return this;
    }

    public OritechRecipeBuilder fluidInput(class_3611 in, float bucketAmount) {
        return this.fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }

    public OritechRecipeBuilder specificFluidInput(class_3611 in, long amountMillis) {
        return this.fluidInput(new FluidIngredient().withContent(in).withSpecificAmount(amountMillis));
    }

    public OritechRecipeBuilder fluidInput(class_3611 in) {
        return this.fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(class_6862<class_3611> in) {
        return this.fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(class_6862<class_3611> in, float bucketAmount) {
        return this.fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }

    public OritechRecipeBuilder fluidOutput(FluidStack out) {
        this.fluidOutputs.add(out);
        return this;
    }

    public OritechRecipeBuilder fluidOutput(class_3611 out, float bucketAmount) {
        return this.fluidOutput(FluidStack.create((class_3611)out, (long)((long)(bucketAmount * (float)FluidStackHooks.bucketAmount()))));
    }

    public OritechRecipeBuilder fluidOutput(class_3611 out) {
        return this.fluidOutput(FluidStack.create((class_3611)out, (long)FluidStackHooks.bucketAmount()));
    }

    public OritechRecipeBuilder result(class_1799 out) {
        if (this.results == null) {
            this.results = new ArrayList<class_1799>();
        }
        this.results.add(out);
        return this;
    }

    public OritechRecipeBuilder result(List<class_1799> out) {
        if (this.results == null) {
            this.results = new ArrayList<class_1799>();
        }
        this.results.addAll(out);
        return this;
    }

    public OritechRecipeBuilder result(class_1792 out, int count) {
        return this.result(new class_1799((class_1935)out, count));
    }

    public OritechRecipeBuilder result(class_1792 out) {
        return this.result(out, 1);
    }

    public OritechRecipeBuilder result(Optional<class_1792> out, int count) {
        if (out.isPresent()) {
            return this.result((class_1792)out.get(), count);
        }
        return this;
    }

    public OritechRecipeBuilder result(Optional<class_1792> out) {
        return this.result(out, 1);
    }

    public OritechRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public OritechRecipeBuilder timeInSeconds(int time) {
        return this.time(time * 20);
    }

    public OritechRecipeBuilder timeMultiplier(float timeMultiplier) {
        this.timeMultiplier = timeMultiplier;
        return this;
    }

    public OritechRecipeBuilder addToGrinder() {
        this.addToGrinder = true;
        return this;
    }

    public abstract void validate(class_2960 var1) throws IllegalStateException;

    public void export(class_8790 exporter, String suffix, String namespace) {
        class_2960 id = class_2960.method_60655((String)namespace, (String)(this.resourcePath + "/" + suffix));
        this.validate(id);
        exporter.method_53819(id, (class_1860)new OritechRecipe((int)((float)this.time * this.timeMultiplier), this.inputs != null ? this.inputs : List.of(), this.results != null ? this.results : List.of(), this.type, this.fluidInput != null ? this.fluidInput : FluidIngredient.EMPTY, this.fluidOutputs != null ? this.fluidOutputs : List.of()), null);
    }

    public void export(class_8790 exporter, String suffix) {
        this.export(exporter, suffix, "oritech");
    }
}

