/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.DelegatingInventoryStorage;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class MachineBlockEntity
extends NetworkedBlockEntity
implements ExtendedMenuProvider,
GeoBlockEntity,
EnergyApi.BlockProvider,
ScreenProvider,
ItemApi.BlockProvider,
RedstoneAddonBlockEntity.RedstoneControllable {
    public static final RawAnimation PACKAGED = RawAnimation.begin().thenPlayAndHold("packaged");
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("deploy");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlayAndHold("idle");
    public static final RawAnimation WORKING = RawAnimation.begin().thenPlay("working");
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK})
    public int progress;
    @SyncField(value={SyncType.GUI_TICK})
    protected OritechRecipe currentRecipe = OritechRecipe.DUMMY;
    @SyncField(value={SyncType.GUI_TICK})
    protected InventoryInputMode inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
    @SyncField(value={SyncType.GUI_TICK})
    protected boolean disabledViaRedstone = false;
    @SyncField(value={SyncType.TICK})
    public long lastWorkedAt;
    protected int energyPerTick;
    public final FilteringInventory inventory = new FilteringInventory(this.getInventorySize(), this::method_5431, this.getSlotAssignments());
    private final Map<class_2350, ItemApi.InventoryStorage> sidedInventories = new HashMap<class_2350, ItemApi.InventoryStorage>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::method_5431, this.canEnergyStorageChangeWhileGUIOpen());

    public MachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state);
        this.energyPerTick = energyPerTick;
        if (this.field_11863 != null) {
            this.lastWorkedAt = this.field_11863.method_8510();
        }
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (!this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        Optional<class_8786<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent() && this.canOutputRecipe((OritechRecipe)recipeCandidate.get().comp_1933()) && this.canProceed((OritechRecipe)recipeCandidate.get().comp_1933())) {
            if (this.currentRecipe != recipeCandidate.get().comp_1933()) {
                this.resetProgress();
            }
            if (this.hasEnoughEnergy()) {
                OritechRecipe activeRecipe;
                this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().comp_1933();
                this.lastWorkedAt = world.method_8510();
                this.useEnergy();
                ++this.progress;
                if (this.checkCraftingFinished(activeRecipe)) {
                    this.craftItem(activeRecipe, this.getOutputView(), this.getInputView());
                    this.resetProgress();
                }
                this.method_5431();
            }
        } else if (this.progress > 0) {
            this.resetProgress();
        }
    }

    protected boolean canProceed(OritechRecipe value) {
        return true;
    }

    protected boolean hasEnoughEnergy() {
        return (float)this.energyStorage.amount >= this.calculateEnergyUsage();
    }

    protected void useEnergy() {
        this.energyStorage.amount = (long)((float)this.energyStorage.amount - this.calculateEnergyUsage());
    }

    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * this.getEfficiencyMultiplier() * (1.0f / this.getSpeedMultiplier());
    }

    public List<class_1799> getCraftingResults(OritechRecipe activeRecipe) {
        return activeRecipe.getResults();
    }

    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        List<class_1799> results = this.getCraftingResults(activeRecipe);
        List<class_1856> inputs = activeRecipe.getInputs();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            class_1799 slot = outputInventory.get(i);
            int newCount = slot.method_7947() + result.method_7947();
            if (slot.method_7960()) {
                outputInventory.set(i, result.method_7972());
                continue;
            }
            slot.method_7939(newCount);
        }
        int startOffset = 0;
        block1: for (class_1856 removedIng : inputs) {
            for (int i = 0; i < inputInventory.size(); ++i) {
                class_1799 inputStack = inputInventory.get((i + startOffset) % inputInventory.size());
                if (!removedIng.method_8093(inputStack)) continue;
                inputStack.method_7934(1);
                ++startOffset;
                continue block1;
            }
        }
    }

    protected boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return (float)this.progress >= (float)activeRecipe.getTime() * this.getSpeedMultiplier();
    }

    protected void resetProgress() {
        this.progress = 0;
    }

    public boolean canOutputRecipe(OritechRecipe recipe) {
        class_1263 outInv = this.getOutputInventory();
        if (outInv.method_5442()) {
            return true;
        }
        List<class_1799> results = recipe.getResults();
        for (int i = 0; i < results.size(); ++i) {
            class_1799 result = results.get(i);
            class_1799 outSlot = outInv.method_5438(i);
            if (outSlot.method_7960() || this.canAddToSlot(result, outSlot)) continue;
            return false;
        }
        return true;
    }

    protected boolean canAddToSlot(class_1799 input, class_1799 slot) {
        if (slot.method_7960()) {
            return true;
        }
        if (!slot.method_7909().equals(input.method_7909())) {
            return false;
        }
        return slot.method_7947() + input.method_7947() <= slot.method_7914();
    }

    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        if (this.currentRecipe != null && this.currentRecipe != OritechRecipe.DUMMY && this.currentRecipe.method_8115(this.getInputInventory(), this.field_11863)) {
            return Optional.of(new class_8786(this.currentRecipe.getOriType().getIdentifier(), (class_1860)this.currentRecipe));
        }
        return this.field_11863.method_8433().method_8132((class_3956)this.getOwnRecipeType(), this.getInputInventory(), this.field_11863);
    }

    protected abstract OritechRecipeType getOwnRecipeType();

    public abstract InventorySlotAssignment getSlotAssignments();

    protected List<class_1799> getInputView() {
        InventorySlotAssignment slots = this.getSlotAssignments();
        return this.inventory.heldStacks.subList(slots.inputStart(), slots.inputStart() + slots.inputCount());
    }

    protected List<class_1799> getOutputView() {
        InventorySlotAssignment slots = this.getSlotAssignments();
        return this.inventory.heldStacks.subList(slots.outputStart(), slots.outputStart() + slots.outputCount());
    }

    protected class_9695 getInputInventory() {
        return new SimpleCraftingInventory((class_1799[])this.getInputView().toArray(class_1799[]::new));
    }

    protected class_1263 getOutputInventory() {
        return new class_1277((class_1799[])this.getOutputView().toArray(class_1799[]::new));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10569("oritech.machine_progress", this.progress);
        nbt.method_10544("oritech.machine_energy", this.energyStorage.amount);
        nbt.method_10575("oritech.machine_input_mode", (short)this.inventoryInputMode.ordinal());
        nbt.method_10556("oritech.redstone", this.disabledViaRedstone);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("oritech.machine_progress");
        this.energyStorage.amount = nbt.method_10537("oritech.machine_energy");
        this.inventoryInputMode = InventoryInputMode.values()[nbt.method_10568("oritech.machine_input_mode")];
        this.disabledViaRedstone = nbt.method_10577("oritech.redstone");
    }

    private int findLowestMatchingSlot(class_1799 stack, List<class_1799> inv, boolean allowEmpty) {
        int lowestMatchingIndex = -1;
        int lowestMatchingCount = 64;
        for (int i = 0; i < inv.size(); ++i) {
            class_1799 invSlot = inv.get(i);
            if (invSlot.method_7960() && allowEmpty) {
                return i;
            }
            if (!invSlot.method_7909().equals(stack.method_7909()) || invSlot.method_7947() >= lowestMatchingCount) continue;
            lowestMatchingIndex = i;
            lowestMatchingCount = invSlot.method_7947();
        }
        return lowestMatchingIndex;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::onAnimationUpdate).triggerableAnim("setup", SETUP).setAnimationSpeedHandler(animatable -> this.getAnimationSpeed()).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler(this::getAnimationSpeed)));
    }

    public PlayState onAnimationUpdate(AnimationState<MachineBlockEntity> state) {
        if (state.getController().isPlayingTriggeredAnimation()) {
            return PlayState.CONTINUE;
        }
        if (this.isActive(this.method_11010())) {
            if (this.isActivelyWorking()) {
                return state.setAndContinue(WORKING);
            }
            return state.setAndContinue(IDLE);
        }
        return state.setAndContinue(PACKAGED);
    }

    public boolean isActivelyWorking() {
        return this.field_11863.method_8510() - this.lastWorkedAt < 15L;
    }

    protected float getAnimationSpeed() {
        if (this.getRecipeDuration() < 0) {
            return 1.0f;
        }
        float recipeTicks = (float)this.getRecipeDuration() * this.getSpeedMultiplier();
        return (float)this.getAnimationDuration() / recipeTicks * 0.99f;
    }

    public int getAnimationDuration() {
        return 60;
    }

    protected int getRecipeDuration() {
        return this.getCurrentRecipe().getTime();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    protected class_2350 getFacing() {
        return (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12481);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public abstract List<ScreenProvider.GuiSlot> getGuiSlots();

    @Override
    public float getProgress() {
        return (float)this.progress / ((float)this.currentRecipe.getTime() * this.getSpeedMultiplier());
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public DynamicEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public OritechRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(OritechRecipe currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public float getEfficiencyMultiplier() {
        return 1.0f;
    }

    public void cycleInputMode() {
        switch (this.inventoryInputMode) {
            case FILL_LEFT_TO_RIGHT: {
                this.inventoryInputMode = InventoryInputMode.FILL_EVENLY;
                break;
            }
            case FILL_EVENLY: {
                this.inventoryInputMode = InventoryInputMode.SIDED;
                break;
            }
            case SIDED: {
                this.inventoryInputMode = InventoryInputMode.FILL_LEFT_TO_RIGHT;
            }
        }
        this.method_5431();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return this.inventoryInputMode;
    }

    public abstract int getInventorySize();

    public boolean isActive(class_2680 state) {
        return true;
    }

    public void setEnergyStored(long amount) {
        this.energyStorage.amount = amount;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return this.calculateEnergyUsage();
    }

    public long getDefaultCapacity() {
        return 5000L;
    }

    public long getDefaultInsertRate() {
        return 1024L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public long getDefaultExtractionRate() {
        return 0L;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        if (this.inventoryInputMode.equals((Object)InventoryInputMode.SIDED)) {
            return this.sidedInventories.computeIfAbsent(direction, this::getDirectedStorage);
        }
        return this.inventory;
    }

    @Override
    public int getComparatorEnergyAmount() {
        return (int)((float)this.energyStorage.amount / (float)this.energyStorage.capacity * 15.0f);
    }

    @Override
    public int getComparatorSlotAmount(int slot) {
        if (this.inventory.heldStacks.size() <= slot) {
            return 0;
        }
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return 0;
        }
        return (int)((float)stack.method_7947() / (float)stack.method_7914() * 15.0f);
    }

    @Override
    public int getComparatorProgress() {
        if (this.currentRecipe.getTime() <= 0) {
            return 0;
        }
        return (int)((float)this.progress / (float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * 15.0f);
    }

    @Override
    public int getComparatorActiveState() {
        return this.isActivelyWorking() ? 15 : 0;
    }

    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }

    public boolean canEnergyStorageChangeWhileGUIOpen() {
        return false;
    }

    public static void receiveCycleModePacket(InventoryInputModeSelectorPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = player.method_37908().method_8321(packet.position());
        if (class_25862 instanceof MachineBlockEntity) {
            MachineBlockEntity machineBlock = (MachineBlockEntity)class_25862;
            machineBlock.cycleInputMode();
        }
    }

    public ItemApi.InventoryStorage getDirectedStorage(class_2350 direction) {
        InventorySlotAssignment slots = this.getSlotAssignments();
        if (slots.inputCount() <= 1) {
            return this.inventory;
        }
        if (direction == null) {
            return this.inventory;
        }
        if (direction.equals((Object)class_2350.field_11036)) {
            return new DelegatingInventoryStorage(this, this.inventory, () -> true){

                @Override
                public int extract(class_1799 extracted, boolean simulate) {
                    return 0;
                }

                @Override
                public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
                    return 0;
                }

                @Override
                public boolean supportsExtraction() {
                    return false;
                }
            };
        }
        if (direction.equals((Object)class_2350.field_11033)) {
            return new DelegatingInventoryStorage(this, this.inventory, () -> true){

                @Override
                public int insert(class_1799 inserted, boolean simulate) {
                    return 0;
                }

                @Override
                public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
                    return 0;
                }

                @Override
                public boolean supportsInsertion() {
                    return false;
                }
            };
        }
        int horizontalOrdinal = 0;
        if (direction.equals((Object)class_2350.field_11034)) {
            horizontalOrdinal = 1;
        }
        if (direction.equals((Object)class_2350.field_11035)) {
            horizontalOrdinal = 2;
        }
        if (direction.equals((Object)class_2350.field_11039)) {
            horizontalOrdinal = 3;
        }
        final int inputSlotIndex = slots.inputStart() + horizontalOrdinal % slots.inputCount();
        return new DelegatingInventoryStorage(this, this.inventory, () -> true){

            @Override
            public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
                if (slot != inputSlotIndex) {
                    return 0;
                }
                return super.insertToSlot(inserted, slot, simulate);
            }

            @Override
            public int insert(class_1799 inserted, boolean simulate) {
                return this.insertToSlot(inserted, inputSlotIndex, simulate);
            }
        };
    }

    public class FilteringInventory
    extends InOutInventoryStorage {
        public FilteringInventory(int size, Runnable onUpdate, InventorySlotAssignment slotAssignment) {
            super(size, onUpdate, slotAssignment);
        }

        @Override
        public int insert(class_1799 toInsert, boolean simulate) {
            if (MachineBlockEntity.this.inventoryInputMode.equals((Object)InventoryInputMode.FILL_EVENLY)) {
                int remaining = toInsert.method_7947();
                int slotCountTarget = toInsert.method_7947() / MachineBlockEntity.this.getSlotAssignments().inputCount();
                slotCountTarget = Math.clamp((long)slotCountTarget, 1, remaining);
                int lowestSlot = 0;
                int lowestSlotCount = Integer.MAX_VALUE;
                for (int i = MachineBlockEntity.this.getSlotAssignments().inputStart(); i < MachineBlockEntity.this.getSlotAssignments().inputStart() + MachineBlockEntity.this.getSlotAssignments().inputCount(); ++i) {
                    class_1799 content = this.method_5438(i);
                    if (!content.method_7960() && !content.method_7909().equals(toInsert.method_7909()) || content.method_7947() >= lowestSlotCount) continue;
                    lowestSlotCount = content.method_7947();
                    lowestSlot = i;
                }
                for (int slot = 0; slot < this.method_5439() && remaining > 0; remaining -= this.customSlotInsert(toInsert.method_46651(slotCountTarget), (slot + lowestSlot) % this.method_5439(), simulate), ++slot) {
                }
                return toInsert.method_7947() - remaining;
            }
            return super.insert(toInsert, simulate);
        }

        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            if (MachineBlockEntity.this.inventoryInputMode.equals((Object)InventoryInputMode.FILL_EVENLY)) {
                return this.insert(addedStack, simulate);
            }
            return this.customSlotInsert(addedStack, slot, simulate);
        }

        private int customSlotInsert(class_1799 toInsert, int slot, boolean simulate) {
            return super.insertToSlot(toInsert, slot, simulate);
        }
    }

    public record InventoryInputModeSelectorPacket(class_2338 position) implements class_8710
    {
        public static final class_8710.class_9154<InventoryInputModeSelectorPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("input_mode"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

