/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SizedIngredient;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AugmentApplicationEntity
extends NetworkedBlockEntity
implements MultiblockMachineController,
GeoBlockEntity,
ExtendedMenuProvider,
ItemApi.BlockProvider,
EnergyApi.BlockProvider,
ScreenProvider {
    public static long maxEnergyTransfer = Oritech.CONFIG.augmenterMaxEnergy() / 10L;
    public static long maxEnergyStored = Oritech.CONFIG.augmenterMaxEnergy();
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final Set<class_2960> researchedAugments = new HashSet<class_2960>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final HashMap<Integer, ResearchState> availableStations = new HashMap();
    public boolean screenInvOverride = false;
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(5, this::method_5431);
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(maxEnergyTransfer, maxEnergyStored, maxEnergyStored, this::method_5431);

    public AugmentApplicationEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PLAYER_MODIFIER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        this.screenInvOverride = false;
        for (int i = 0; i < 3; ++i) {
            boolean isDone;
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || !station.working) continue;
            boolean bl = isDone = world.method_8510() > station.researchStartedAt + (long)station.workTime;
            if (!isDone) continue;
            this.researchedAugments.add(station.selectedResearch);
            station.working = false;
            this.method_5431();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10544("rf", this.energyStorage.getAmount());
        this.addMultiblockToNbt(nbt);
        class_2499 list = new class_2499();
        for (class_2960 augment : this.researchedAugments) {
            list.add((Object)class_2519.method_23256((String)augment.method_12832()));
        }
        for (ResearchState station : this.availableStations.values()) {
            if (station == null || !station.working) continue;
            list.add((Object)class_2519.method_23256((String)station.selectedResearch.method_12832()));
        }
        nbt.method_10566("researched", (class_2520)list);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.energyStorage.setAmount(nbt.method_10537("rf"));
        this.loadMultiblockNbtData(nbt);
        class_2499 parsedList = nbt.method_10554("researched", 8);
        for (class_2520 element : parsedList) {
            class_2960 id = Oritech.id(element.method_10714());
            this.researchedAugments.add(id);
        }
    }

    public void researchAugment(class_2960 augment, boolean creative, class_1657 player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to research already researched augment " + String.valueOf(augment));
            return;
        }
        AugmentDataRecipe recipe = (AugmentDataRecipe)((class_8786)this.field_11863.method_8433().method_8130(augment).get()).comp_1933();
        long extracted = this.energyStorage.extract(recipe.getRfCost(), false);
        block0: for (SizedIngredient wantedInput : recipe.getResearchCost()) {
            int takeAmount;
            class_1856 type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (class_1799 stack : this.inventory.heldStacks) {
                if (!type.method_8093(stack)) continue;
                takeAmount = Math.min(stack.method_7947(), missingCount);
                stack.method_7934(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!type.method_8093(stack)) continue;
                takeAmount = Math.min(stack.method_7947(), missingCount);
                stack.method_7934(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        for (int i = 0; i < 3; ++i) {
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || station.working || !class_7923.field_41175.method_10221((Object)station.type).equals((Object)recipe.getRequiredStation())) continue;
            station.selectedResearch = augment;
            station.working = true;
            station.researchStartedAt = this.field_11863.method_8510();
            station.workTime = creative ? 5 : recipe.getTime();
            break;
        }
        this.method_5431();
    }

    public void installAugmentToPlayer(class_2960 augment, class_1657 player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (!this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to install augment with id" + String.valueOf(augment) + " without researching it.");
            return;
        }
        AugmentDataRecipe recipe = (AugmentDataRecipe)((class_8786)this.field_11863.method_8433().method_8130(augment).get()).comp_1933();
        block0: for (SizedIngredient wantedInput : recipe.getApplyCost()) {
            int takeAmount;
            class_1856 type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (class_1799 stack : this.inventory.heldStacks) {
                if (!type.method_8093(stack)) continue;
                takeAmount = Math.min(stack.method_7947(), missingCount);
                stack.method_7934(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!type.method_8093(stack)) continue;
                takeAmount = Math.min(stack.method_7947(), missingCount);
                stack.method_7934(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.installToPlayer(player);
        this.method_5431();
        player.method_37908().method_45447(null, player.method_24515(), SoundContent.SHORT_SERVO, class_3419.field_15245);
    }

    public void removeAugmentFromPlayer(class_2960 augment, class_1657 player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.removeFromPlayer(player);
        this.method_5431();
    }

    public static void toggleAugmentForPlayer(class_2960 augment, class_1657 player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        if (!augmentInstance.isInstalled(player)) {
            Oritech.LOGGER.error("Tried toggling not-installed augment id: " + String.valueOf(augment) + ". This should never happen");
            return;
        }
        augmentInstance.toggle(player);
    }

    public boolean hasPlayerAugment(class_2960 augment, class_1657 player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return false;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        return augmentInstance.isInstalled(player);
    }

    public void loadResearchesFromPlayer(class_1657 player) {
        for (class_2960 augmentId : PlayerAugments.allAugments.keySet()) {
            Augment augment = PlayerAugments.allAugments.get(augmentId);
            boolean isInstalled = augment.isInstalled(player);
            boolean isResearched = this.researchedAugments.contains(augmentId);
            if (!isInstalled || isResearched) continue;
            this.researchedAugments.add(augmentId);
        }
    }

    public void loadAvailableStations(class_1657 player) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        List<class_2338> targetPositions = List.of(new class_2338(0, 0, -2), new class_2338(1, 0, 2), new class_2338(2, 0, -1));
        for (int i = 0; i < targetPositions.size(); ++i) {
            class_2338 candidatePosOffset = targetPositions.get(i);
            class_2338 candidatePos = new class_2338(Geometry.offsetToWorldPosition(facing, (class_2382)candidatePosOffset, (class_2382)this.field_11867));
            class_2680 candidateState = this.field_11863.method_8320(candidatePos);
            if (!(candidateState.method_26204() instanceof AugmentResearchStationBlock) || !((Boolean)candidateState.method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue() || this.availableStations.containsKey(i) && this.availableStations.get(i) != null && this.availableStations.get((Object)Integer.valueOf((int)i)).type.equals(candidateState.method_26204())) continue;
            ResearchState newState = new ResearchState(candidateState.method_26204(), false, class_2960.method_60654((String)""), -1, -1L);
            this.availableStations.put(i, newState);
        }
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 0, 1), new class_2382(0, 0, -1), new class_2382(-1, 0, 0), new class_2382(-1, 0, 1), new class_2382(-1, 0, -1), new class_2382(0, 1, 1), new class_2382(0, 1, -1), new class_2382(-1, 1, 0), new class_2382(-1, 1, 1), new class_2382(-1, 1, -1));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        class_2680 state = this.method_11010();
        return ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "setup");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                }
                return state.setAndContinue(MachineBlockEntity.SETUP);
            }
            if (((Boolean)this.method_11010().method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue()) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()).triggerableAnim("setup", MachineBlockEntity.SETUP));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        this.sendUpdate(SyncType.GUI_OPEN);
        double dist = player.method_5707(this.field_11867.method_61082());
        if (dist > 1.0 || this.screenInvOverride) {
            return new BasicMachineScreenHandler(syncId, playerInventory, this);
        }
        return new PlayerModifierScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 30, 30), new ScreenProvider.GuiSlot(1, 50, 30), new ScreenProvider.GuiSlot(2, 70, 30), new ScreenProvider.GuiSlot(3, 90, 30), new ScreenProvider.GuiSlot(4, 110, 30));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.AUGMENTER_INV_SCREEN;
    }

    public static class ResearchState {
        public class_2248 type;
        public boolean working;
        public class_2960 selectedResearch;
        public int workTime;
        public long researchStartedAt;
        public static class_9139<class_9129, ResearchState> PACKET_CODEC = class_9139.method_56906((class_9139)class_2960.field_48267.method_56432(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)), ResearchState::getType, (class_9139)class_9135.field_48547, ResearchState::getWorking, (class_9139)class_2960.field_48267, ResearchState::getSelectedResearch, (class_9139)class_9135.field_49675, ResearchState::getWorkTime, (class_9139)class_9135.field_48551, ResearchState::getResearchStartedAt, ResearchState::new);

        public class_2248 getType() {
            return this.type;
        }

        public int getWorkTime() {
            return this.workTime;
        }

        public class_2960 getSelectedResearch() {
            return this.selectedResearch;
        }

        public long getResearchStartedAt() {
            return this.researchStartedAt;
        }

        public boolean getWorking() {
            return this.working;
        }

        public ResearchState(class_2248 type, boolean working, class_2960 selectedResearch, int workTime, long researchStartedAt) {
            this.type = type;
            this.working = working;
            this.selectedResearch = selectedResearch;
            this.workTime = workTime;
            this.researchStartedAt = researchStartedAt;
        }

        public String toString() {
            return "ResearchState{type=" + String.valueOf(this.type) + ", working=" + this.working + ", selectedResearch=" + String.valueOf(this.selectedResearch) + ", workTime=" + this.workTime + ", researchStartedAt=" + this.researchStartedAt + "}";
        }
    }
}

