/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.reactor.BaseReactorBlock;
import rearth.oritech.block.blocks.reactor.ReactorAbsorberBlock;
import rearth.oritech.block.blocks.reactor.ReactorEnergyPortBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatPipeBlock;
import rearth.oritech.block.blocks.reactor.ReactorHeatVentBlock;
import rearth.oritech.block.blocks.reactor.ReactorRedstonePortBlock;
import rearth.oritech.block.blocks.reactor.ReactorReflectorBlock;
import rearth.oritech.block.blocks.reactor.ReactorRodBlock;
import rearth.oritech.block.blocks.reactor.ReactorWallBlock;
import rearth.oritech.block.entity.reactor.ReactorAbsorberPortEntity;
import rearth.oritech.block.entity.reactor.ReactorFuelPortEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.ReactorScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.util.Geometry;

public class ReactorControllerBlockEntity
extends NetworkedBlockEntity
implements EnergyApi.BlockProvider,
ExtendedMenuProvider {
    public static final int MAX_SIZE = Oritech.CONFIG.maxSize();
    public static final int RF_PER_PULSE = Oritech.CONFIG.rfPerPulse();
    public static final int ABSORBER_RATE = Oritech.CONFIG.absorberRate();
    public static final int VENT_BASE_RATE = Oritech.CONFIG.ventBaseRate();
    public static final int VENT_RELATIVE_RATE = Oritech.CONFIG.ventRelativeRate();
    public static final int MAX_HEAT = Oritech.CONFIG.maxHeat();
    public static final int MAX_UNSTABLE_TICKS = Oritech.CONFIG.maxUnstableTicks();
    private final HashMap<Vector2i, BaseReactorBlock> activeComponents = new HashMap();
    private final HashMap<Vector2i, ReactorFuelPortEntity> fuelPorts = new HashMap();
    private final HashMap<Vector2i, ReactorAbsorberPortEntity> absorberPorts = new HashMap();
    private final HashMap<Vector2i, Integer> componentHeats = new HashMap();
    private final HashSet<class_3545<class_2338, class_2350>> energyPorts = new HashSet();
    private final HashSet<class_2338> redstonePorts = new HashSet();
    @SyncField(value={SyncType.GUI_TICK})
    public final HashMap<Vector2i, ComponentStatistics> componentStats = new HashMap();
    @SyncField(value={SyncType.GUI_TICK})
    public SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(0L, Oritech.CONFIG.reactorMaxEnergyStored(), Oritech.CONFIG.reactorMaxEnergyStored(), this::method_5431);
    public boolean active = false;
    @SyncField(value={SyncType.GUI_OPEN})
    public class_2338 areaMin;
    @SyncField(value={SyncType.GUI_OPEN})
    public class_2338 areaMax;
    private int reactorStackHeight;
    private boolean disabledViaRedstone = false;
    private int unstableTicks = 0;
    public long disabledUntil = 0L;
    private boolean doAutoInit = false;

    public ReactorControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (!this.active && this.doAutoInit) {
            this.doAutoInit = false;
            this.init(null);
        }
        if (!this.active || this.activeComponents.isEmpty()) {
            return;
        }
        int activeRods = 0;
        int hottestHeat = 0;
        for (Map.Entry<Vector2i, BaseReactorBlock> entry : this.activeComponents.entrySet()) {
            Vector2i localPos = entry.getKey();
            BaseReactorBlock component = entry.getValue();
            Integer componentHeat = this.componentHeats.get(localPos);
            if (component instanceof ReactorRodBlock) {
                ReactorRodBlock rodBlock = (ReactorRodBlock)component;
                int ownRodCount = rodBlock.getRodCount();
                int receivedPulses = rodBlock.getInternalPulseCount();
                ReactorFuelPortEntity portEntity = this.fuelPorts.get(localPos);
                if (portEntity == null || portEntity.method_11015()) continue;
                boolean hasFuel = portEntity.tryConsumeFuel(ownRodCount * this.reactorStackHeight, this.isDisabled() || this.disabledViaRedstone);
                int heatCreated = 0;
                this.setRodBlockState(localPos, hasFuel);
                if (hasFuel) {
                    for (Vector2i neighborPos : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                        BaseReactorBlock neighbor = this.activeComponents.get(neighborPos);
                        if (neighbor instanceof ReactorRodBlock) {
                            ReactorRodBlock neighborRod = (ReactorRodBlock)neighbor;
                            receivedPulses += neighborRod.getRodCount();
                            continue;
                        }
                        if (!(neighbor instanceof ReactorReflectorBlock)) continue;
                        ReactorReflectorBlock reflectorBlock = (ReactorReflectorBlock)neighbor;
                        receivedPulses += rodBlock.getRodCount();
                    }
                    if (!this.isDisabled()) {
                        ++activeRods;
                        this.energyStorage.insertIgnoringLimit(RF_PER_PULSE * receivedPulses * this.reactorStackHeight, false);
                    }
                    heatCreated = receivedPulses / 2 * receivedPulses + 4;
                    if ((double)(componentHeat = Integer.valueOf(componentHeat + heatCreated)).intValue() > (double)MAX_HEAT * 0.85) {
                        this.playMeltdownAnimation(portEntity.method_11016());
                    }
                } else {
                    receivedPulses = 0;
                }
                this.componentStats.put(localPos, new ComponentStatistics((short)receivedPulses, componentHeat, (short)heatCreated));
            } else if (component instanceof ReactorHeatPipeBlock) {
                ReactorHeatPipeBlock heatPipeBlock = (ReactorHeatPipeBlock)component;
                int sumGainedHeat = 0;
                for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                    Integer neighborHeat = this.componentHeats.get(neighbor);
                    if (neighborHeat <= componentHeat) continue;
                    int diff = neighborHeat - componentHeat;
                    int gainedHeat = Math.min(diff / 4 + 10, diff);
                    neighborHeat = neighborHeat - gainedHeat;
                    this.componentHeats.put(neighbor, neighborHeat);
                    componentHeat = componentHeat + gainedHeat;
                    sumGainedHeat += gainedHeat;
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, componentHeat, (short)sumGainedHeat));
            } else if (component instanceof ReactorAbsorberBlock) {
                ReactorAbsorberBlock absorberBlock = (ReactorAbsorberBlock)component;
                int sumRemovedHeat = 0;
                ReactorAbsorberPortEntity portEntity = this.absorberPorts.get(localPos);
                if (portEntity == null || portEntity.method_11015()) continue;
                int fuelAvailable = portEntity.getAvailableFuel();
                if (fuelAvailable >= this.reactorStackHeight) {
                    for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                        Integer neighborHeat = this.componentHeats.get(neighbor);
                        if (neighborHeat <= 0) continue;
                        neighborHeat = neighborHeat - ABSORBER_RATE;
                        sumRemovedHeat += ABSORBER_RATE;
                        this.componentHeats.put(neighbor, neighborHeat);
                    }
                } else if (fuelAvailable > 0) {
                    portEntity.consumeFuel(fuelAvailable);
                }
                if (sumRemovedHeat > 0) {
                    portEntity.consumeFuel(this.reactorStackHeight);
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, 0, (short)sumRemovedHeat));
            } else if (component instanceof ReactorHeatVentBlock) {
                ReactorHeatVentBlock ventBlock = (ReactorHeatVentBlock)component;
                Vector2i hottestPos = localPos;
                int max = 0;
                for (Vector2i neighbor : ReactorControllerBlockEntity.getNeighborsInBounds(localPos, this.activeComponents.keySet())) {
                    Integer neighborHeat = this.componentHeats.get(neighbor);
                    if (neighborHeat <= max) continue;
                    hottestPos = neighbor;
                    max = neighborHeat;
                }
                int removed = 0;
                if (max != 0) {
                    int neighborHeat = max;
                    removed = Math.min(neighborHeat / VENT_RELATIVE_RATE + VENT_BASE_RATE, neighborHeat);
                    this.componentHeats.put(hottestPos, neighborHeat -= removed);
                }
                this.componentStats.put(localPos, new ComponentStatistics(0, 0, (short)removed));
            }
            this.componentHeats.put(localPos, componentHeat);
            if (componentHeat <= hottestHeat) continue;
            hottestHeat = componentHeat;
        }
        this.outputEnergy();
        this.updateRedstonePorts(hottestHeat, activeRods);
        if (activeRods > 0) {
            this.playAmbientSound();
        }
        if (activeRods > 0 && (float)hottestHeat > (float)MAX_HEAT * 0.8f) {
            this.playWarningSound();
        }
        if (hottestHeat > MAX_HEAT && activeRods > 0) {
            ++this.unstableTicks;
            if (this.unstableTicks > MAX_UNSTABLE_TICKS) {
                this.doReactorExplosion(activeRods * this.reactorStackHeight);
            }
        } else {
            this.unstableTicks = 0;
        }
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        if (type != SyncType.GUI_TICK) {
            return;
        }
        for (ReactorFuelPortEntity reactorFuelPortEntity : this.fuelPorts.values()) {
            reactorFuelPortEntity.updateNetwork();
        }
        for (ReactorAbsorberPortEntity reactorAbsorberPortEntity : this.absorberPorts.values()) {
            reactorAbsorberPortEntity.updateNetwork();
        }
    }

    private boolean isDisabled() {
        return this.field_11863.method_8510() < this.disabledUntil;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy_stored", this.energyStorage.getAmount());
        nbt.method_10556("was_active", this.active);
        nbt.method_10556("redstone_disabled", this.disabledViaRedstone);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.energyStorage.setAmount(nbt.method_10537("energy_stored"));
        this.doAutoInit = nbt.method_10577("was_active");
        this.disabledViaRedstone = nbt.method_10577("redstone_disabled");
    }

    private void playMeltdownAnimation(class_2338 port) {
        ParticleContent.MELTDOWN_IMMINENT.spawn(this.field_11863, port.method_46558().method_1031(0.0, 0.3, 0.0), (Object)5);
    }

    private void playAmbientSound() {
        int soundDuration = 250;
        if (this.field_11863.method_8510() % (long)soundDuration == 0L) {
            this.field_11863.method_8396(null, this.field_11867, SoundContent.REACTOR, class_3419.field_15245, 0.7f, 0.8f);
        }
    }

    private void playWarningSound() {
        int soundDuration = 50;
        if (this.field_11863.method_8510() % (long)soundDuration == 0L) {
            this.field_11863.method_8396(null, this.field_11867, SoundContent.REACTOR_WARNING, class_3419.field_15245, 4.0f, 0.8f);
        }
    }

    private void doReactorExplosion(int strength) {
        if (Oritech.CONFIG.safeMode()) {
            this.disableReactor();
            return;
        }
        class_2248 spawnedBlock = BlockContent.REACTOR_EXPLOSION_SMALL;
        if (strength > 8 && strength <= 25) {
            spawnedBlock = BlockContent.REACTOR_EXPLOSION_MEDIUM;
        } else if (strength > 25) {
            spawnedBlock = BlockContent.REACTOR_EXPLOSION_LARGE;
        }
        this.field_11863.method_8501(this.field_11867, spawnedBlock.method_9564());
    }

    private void disableReactor() {
        this.disabledUntil = this.field_11863.method_8510() + (long)Oritech.CONFIG.safeModeCooldown();
    }

    public void init(@Nullable class_1657 player) {
        this.active = false;
        class_2338 cornerA = this.field_11867;
        cornerA = this.expandWall(cornerA, new class_2382(0, -1, 0), true);
        cornerA = this.expandWall(cornerA, new class_2382(0, 0, -1));
        cornerA = this.expandWall(cornerA, new class_2382(-1, 0, 0));
        class_2338 cornerB = cornerA = this.expandWall(cornerA, new class_2382(0, 0, -1));
        cornerB = this.expandWall(cornerB, new class_2382(0, 1, 0));
        cornerB = this.expandWall(cornerB, new class_2382(0, 0, 1));
        cornerB = this.expandWall(cornerB, new class_2382(1, 0, 0));
        if (cornerA == this.field_11867 || cornerB == this.field_11867 || cornerA == cornerB || ReactorControllerBlockEntity.onSameAxis(cornerA, cornerB)) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.reactor_edge_invalid"));
            }
            return;
        }
        class_2338 finalCornerA = cornerA;
        class_2338 finalCornerB = cornerB;
        this.energyPorts.clear();
        this.redstonePorts.clear();
        boolean wallsValid = class_2338.method_20437((class_2338)cornerA, (class_2338)cornerB).allMatch(pos -> {
            if (ReactorControllerBlockEntity.isAtEdgeOfBox(pos, finalCornerA, finalCornerB)) {
                class_2248 block = this.field_11863.method_8320(pos).method_26204();
                return block instanceof ReactorWallBlock;
            }
            if (ReactorControllerBlockEntity.isOnWall(pos, finalCornerA, finalCornerB)) {
                BaseReactorBlock reactorBlock;
                class_2680 state = this.field_11863.method_8320(pos);
                class_2248 block = state.method_26204();
                if (block instanceof ReactorEnergyPortBlock) {
                    class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
                    class_2338 blockInFront = pos.method_10081(Geometry.getForward(facing));
                    this.energyPorts.add((class_3545<class_2338, class_2350>)new class_3545((Object)blockInFront, (Object)class_2350.method_50026((int)Geometry.getBackward(facing).method_10263(), (int)Geometry.getBackward(facing).method_10264(), (int)Geometry.getBackward(facing).method_10260())));
                } else if (block instanceof ReactorRedstonePortBlock) {
                    this.redstonePorts.add(pos.method_10062());
                }
                return !(block instanceof BaseReactorBlock) || (reactorBlock = (BaseReactorBlock)block).validForWalls();
            }
            return true;
        });
        if (!wallsValid) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.reactor_wall_invalid"));
            }
            return;
        }
        int interiorHeight = cornerB.method_10264() - cornerA.method_10264() - 1;
        class_2338 cornerAFlat = cornerA.method_10069(1, 1, 1);
        class_2338 cornerBFlat = new class_2338(cornerB.method_10263() - 1, cornerA.method_10264() + 1, cornerB.method_10260() - 1);
        this.fuelPorts.clear();
        this.absorberPorts.clear();
        this.reactorStackHeight = interiorHeight;
        boolean interiorStackedRight = class_2338.method_20437((class_2338)cornerAFlat, (class_2338)cornerBFlat).allMatch(pos -> {
            class_2338 offset = pos.method_10059((class_2382)cornerAFlat);
            Vector2i localPos = new Vector2i(offset.method_10263(), offset.method_10260());
            class_2248 block = this.field_11863.method_8320(pos).method_26204();
            if (!(block instanceof BaseReactorBlock)) {
                return true;
            }
            BaseReactorBlock reactorBlock = (BaseReactorBlock)block;
            for (int i = 1; i < interiorHeight; ++i) {
                class_2338 candidatePos = pos.method_10069(0, i, 0);
                class_2680 candidate = this.field_11863.method_8320(candidatePos);
                if (candidate.method_26204().equals(block)) continue;
                return false;
            }
            class_2248 requiredCeiling = reactorBlock.requiredStackCeiling();
            if (requiredCeiling != class_2246.field_10124) {
                class_2338 ceilingPos = pos.method_10069(0, interiorHeight, 0);
                class_2248 ceilingBlock = this.field_11863.method_8320(ceilingPos).method_26204();
                if (!requiredCeiling.equals(ceilingBlock)) {
                    return false;
                }
                if (block instanceof ReactorRodBlock) {
                    this.fuelPorts.put(localPos, (ReactorFuelPortEntity)this.field_11863.method_8321(ceilingPos));
                } else if (block instanceof ReactorAbsorberBlock) {
                    this.absorberPorts.put(localPos, (ReactorAbsorberPortEntity)this.field_11863.method_8321(ceilingPos));
                }
            }
            this.activeComponents.put(localPos, reactorBlock);
            this.componentHeats.putIfAbsent(localPos, 0);
            return true;
        });
        if (!interiorStackedRight) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.reactor_interior_issues"));
            }
            return;
        }
        this.areaMin = finalCornerA;
        this.areaMax = finalCornerB;
        this.active = true;
    }

    private void setRodBlockState(Vector2i localPos, boolean on) {
        if (this.field_11863.method_8510() % 10L != 0L) {
            return;
        }
        class_2338 stackTop = this.fuelPorts.get(localPos).method_11016();
        for (int i = 1; i <= this.reactorStackHeight; ++i) {
            Boolean oldLit;
            class_2338 candidatePos = stackTop.method_10087(i);
            class_2680 candidateState = this.field_11863.method_8320(candidatePos);
            if (!(candidateState.method_26204() instanceof ReactorRodBlock) || (oldLit = (Boolean)candidateState.method_11654((class_2769)class_2741.field_12548)) == on) continue;
            this.field_11863.method_30092(candidatePos, (class_2680)candidateState.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(on)), 2, 0);
        }
    }

    private static Set<Vector2i> getNeighborsInBounds(Vector2i pos, Set<Vector2i> keys) {
        Vector2i d;
        Vector2i c;
        Vector2i b;
        HashSet<Vector2i> res = new HashSet<Vector2i>(4);
        Vector2i a = new Vector2i((Vector2ic)pos).add(-1, 0);
        if (keys.contains(a)) {
            res.add(a);
        }
        if (keys.contains(b = new Vector2i((Vector2ic)pos).add(0, 1))) {
            res.add(b);
        }
        if (keys.contains(c = new Vector2i((Vector2ic)pos).add(1, 0))) {
            res.add(c);
        }
        if (keys.contains(d = new Vector2i((Vector2ic)pos).add(0, -1))) {
            res.add(d);
        }
        return res;
    }

    private static boolean onSameAxis(class_2338 A, class_2338 B) {
        return A.method_10263() == B.method_10263() || A.method_10264() == B.method_10264() || A.method_10260() == B.method_10260();
    }

    private static boolean isOnWall(class_2338 pos, class_2338 min, class_2338 max) {
        return ReactorControllerBlockEntity.onSameAxis(pos, min) || ReactorControllerBlockEntity.onSameAxis(pos, max);
    }

    private static boolean isAtEdgeOfBox(class_2338 pos, class_2338 min, class_2338 max) {
        int planesAligned = 0;
        if (pos.method_10263() == min.method_10263() || pos.method_10263() == max.method_10263()) {
            ++planesAligned;
        }
        if (pos.method_10264() == min.method_10264() || pos.method_10264() == max.method_10264()) {
            ++planesAligned;
        }
        if (pos.method_10260() == min.method_10260() || pos.method_10260() == max.method_10260()) {
            ++planesAligned;
        }
        return planesAligned >= 2;
    }

    private class_2338 expandWall(class_2338 from, class_2382 direction) {
        return this.expandWall(from, direction, false);
    }

    private class_2338 expandWall(class_2338 from, class_2382 direction, boolean allReactorBlocks) {
        class_2338 result = from;
        for (int i = 1; i < MAX_SIZE; ++i) {
            class_2338 candidate = from.method_10081(direction.method_35862(i));
            class_2248 candidateBlock = this.field_11863.method_8320(candidate).method_26204();
            if (!allReactorBlocks && !(candidateBlock instanceof ReactorWallBlock)) {
                return result;
            }
            if (allReactorBlocks && !(candidateBlock instanceof BaseReactorBlock)) {
                return result;
            }
            result = candidate;
        }
        return result;
    }

    private void updateRedstonePorts(int hottestTemp, int filledRods) {
        this.disabledViaRedstone = false;
        for (class_2338 pos : this.redstonePorts) {
            class_2680 state = this.field_11863.method_8320(pos);
            if (!state.method_26204().equals(BlockContent.REACTOR_REDSTONE_PORT)) continue;
            int resOutput = 0;
            Integer mode = (Integer)state.method_11654((class_2769)ReactorRedstonePortBlock.PORT_MODE);
            if (mode == 0 && hottestTemp > 0) {
                resOutput = (int)((float)hottestTemp / (float)MAX_HEAT * 15.0f);
                resOutput = Math.max(resOutput, 1);
            } else if (mode == 1) {
                resOutput = Math.min(filledRods, 15);
            } else if (mode == 2 && this.energyStorage.getAmount() > 0L) {
                float fillPercentage = (float)this.energyStorage.getAmount() / (float)this.energyStorage.getCapacity();
                resOutput = (int)(1.0f + fillPercentage * 14.0f);
            }
            resOutput = Math.min(resOutput, 15);
            Integer lastLevel = (Integer)state.method_11654((class_2769)class_2741.field_12511);
            if (lastLevel != resOutput) {
                this.field_11863.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12511, (Comparable)Integer.valueOf(resOutput)));
                this.field_11863.method_8524(pos);
            }
            if (!this.field_11863.method_49803(pos)) continue;
            this.disabledViaRedstone = true;
        }
    }

    private void outputEnergy() {
        int totalMoved = 0;
        int maxRatePerSlot = Oritech.CONFIG.reactorMaxEnergyOutput();
        ArrayList<class_3545<class_2338, class_2350>> randomOrderedList = new ArrayList<class_3545<class_2338, class_2350>>(this.energyPorts);
        Collections.shuffle(randomOrderedList);
        for (class_3545<class_2338, class_2350> candidateData : randomOrderedList) {
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.field_11863, (class_2338)candidateData.method_15442(), (class_2350)candidateData.method_15441());
            if (candidate == null) continue;
            Long moved = EnergyApi.transfer(this.energyStorage, candidate, maxRatePerSlot, false);
            if (moved > 0L) {
                candidate.update();
            }
            totalMoved = (int)((long)totalMoved + moved);
        }
        if (totalMoved > 0) {
            this.energyStorage.update();
        }
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    public class_2561 method_5476() {
        return class_2561.method_30163((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ReactorScreenHandler(syncId, playerInventory, this);
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public record ComponentStatistics(short receivedPulses, int storedHeat, short heatChanged) {
        public static final ComponentStatistics EMPTY = new ComponentStatistics(0, -1, 0);
    }
}

