/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.ui.PlayerModifierScreen;

public class AugmentSelectionScreen
extends BaseOwoScreen<FlowLayout> {
    private Component lastFocused;
    private LabelComponent noOpButton;
    private FlowLayout root;
    private final List<Component> augments = new ArrayList<Component>();
    private final HashMap<Component, class_2960> augmentIDs = new HashMap();
    private final HashMap<Component, Float> augmentSizes = new HashMap();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.root = rootComponent;
        this.addAugments(rootComponent);
        LabelComponent label = Components.label((class_2561)class_2561.method_43471((String)"oritech.text.augment_toggle"));
        rootComponent.child((Component)label.positioning(Positioning.relative((int)2, (int)90)));
    }

    public void method_25393() {
        Component component;
        super.method_25393();
        if (this.lastFocused == this.noOpButton) {
            this.noOpButton.text((class_2561)class_2561.method_43470((String)"Exit"));
        } else if (this.lastFocused != null && (component = this.lastFocused) instanceof TextureComponent) {
            TextureComponent lastButton = (TextureComponent)component;
            class_2960 focusedAugmentId = this.augmentIDs.get(lastButton);
            if (focusedAugmentId == null) {
                return;
            }
            class_5250 focusedAugment = class_2561.method_43471((String)PlayerModifierScreen.augmentKey(focusedAugmentId));
            this.noOpButton.text((class_2561)focusedAugment);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Vector2i mousePos;
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.augments.isEmpty()) {
            return;
        }
        Component mousingOver = (Component)this.augments.stream().findFirst().get();
        int minDist = Integer.MAX_VALUE;
        for (Component augment : this.augments) {
            mousePos = new Vector2i(mouseX, mouseY);
            Vector2i augmentPos = new Vector2i(augment.x() + augment.width() / 2, augment.y() + augment.height() / 2);
            double dist = mousePos.distance((Vector2ic)augmentPos);
            if (augment == this.noOpButton) {
                dist *= 2.0;
            }
            if (!(dist < (double)minDist)) continue;
            minDist = (int)dist;
            mousingOver = augment;
        }
        this.lastFocused = mousingOver;
        Vector2i centerPos = new Vector2i(this.noOpButton.x() + this.noOpButton.width() / 2, this.noOpButton.y() + this.noOpButton.height() / 2);
        Vector2i selectedPos = new Vector2i(this.lastFocused.x() + this.lastFocused.width() / 2, this.lastFocused.y() + this.lastFocused.height() / 2);
        mousePos = new Vector2i(mouseX, mouseY);
        int mouseLineColor = new Color(0.5882353f, 0.7058824f, 0.8627451f, 0.8f).argb();
        AugmentSelectionScreen.drawLine(context, centerPos, selectedPos, mouseLineColor);
        AugmentSelectionScreen.drawLine(context, selectedPos, mousePos, mouseLineColor);
        int screenSize = this.root.height();
        double innerRadius = 0.175;
        double outerRadius = 0.4;
        int screenSizeX = this.root.width();
        int screenSizeY = this.root.height();
        float middleX = (float)screenSizeX / 2.0f;
        float middleY = (float)screenSizeY / 2.0f;
        int augmentCount = this.augments.size() - 1;
        double radSizePerElement = Math.toRadians(360.0 / (double)augmentCount) * (double)0.8f;
        Vector2i screenMiddle = new Vector2i((int)middleX, (int)middleY);
        for (int i = 0; i < this.augments.size(); ++i) {
            Component augment = this.augments.get(i);
            class_2960 augmentId = this.augmentIDs.get(augment);
            Augment augmentData = PlayerAugments.allAugments.get(augmentId);
            if (augmentData == null) continue;
            boolean isEnabled = augmentData.isEnabled((class_1657)this.field_22787.field_1724);
            boolean active = mousingOver == augment;
            int color = new Color(0.7058824f, 0.11764706f, 0.11764706f, 0.3f).argb();
            if (isEnabled) {
                color = new Color(0.11764706f, 0.7058824f, 0.11764706f, 0.3f).argb();
            }
            if (active) {
                color = new Color(0.627451f, 0.7058824f, 0.8627451f, 0.5f).argb();
            }
            double augmentRad = (double)((float)i / (float)augmentCount * 2.0f) * Math.PI - Math.toRadians(90.0);
            float sizeTarget = 1.0f;
            if (active) {
                sizeTarget = 1.05f;
            }
            Float lastSize = this.augmentSizes.getOrDefault(augment, Float.valueOf(1.0f));
            double usedSize = class_3532.method_16436((double)0.15, (double)lastSize.floatValue(), (double)sizeTarget);
            this.augmentSizes.put(augment, Float.valueOf((float)usedSize));
            double activeInnerRadius = innerRadius / usedSize;
            double activeOuterRadius = outerRadius * usedSize;
            if (i == this.augments.size() - 1) continue;
            AugmentSelectionScreen.drawPieSegmented(context, augmentRad, radSizePerElement, screenMiddle, activeInnerRadius, activeOuterRadius, screenSize, color, 16);
        }
        boolean centerSelected = mousingOver == this.noOpButton;
        int color = new Color(0.627451f, 0.7058824f, 0.7058824f, 0.3f).argb();
        if (centerSelected) {
            color = new Color(0.627451f, 0.7058824f, 0.8627451f, 0.5f).argb();
        }
        AugmentSelectionScreen.drawPieSegmented(context, 0.0, Math.toRadians(360.0), screenMiddle, 0.0, innerRadius * 0.6, screenSize, color, 32);
    }

    private static void drawPieSegmented(class_332 context, double augmentRad, double radSize, Vector2i screenMiddle, double innerRadius, double outerRadius, double screenSize, int color, int segmentCount) {
        double segmentSize = radSize / (double)segmentCount;
        double augmentRadBegin = augmentRad - radSize * 0.5;
        for (int i = 0; i < segmentCount; ++i) {
            double fromRad = augmentRadBegin + segmentSize * (double)i;
            double toRad = fromRad + segmentSize;
            Vector2i a = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(innerRadius * Math.cos(fromRad) * screenSize), (int)(innerRadius * Math.sin(fromRad) * screenSize)));
            Vector2i b = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(outerRadius * Math.cos(fromRad) * screenSize), (int)(outerRadius * Math.sin(fromRad) * screenSize)));
            Vector2i c = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(innerRadius * Math.cos(toRad) * screenSize), (int)(innerRadius * Math.sin(toRad) * screenSize)));
            Vector2i d = new Vector2i((Vector2ic)screenMiddle).add((Vector2ic)new Vector2i((int)(outerRadius * Math.cos(toRad) * screenSize), (int)(outerRadius * Math.sin(toRad) * screenSize)));
            AugmentSelectionScreen.drawRect(context, d, b, a, c, color);
        }
    }

    private static void drawLine(class_332 context, Vector2i from, Vector2i to, int color) {
        if ((double)from.distanceSquared((Vector2ic)to) < 0.1) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        Matrix4f pos = matrices.method_23760().method_23761();
        Vector2f normal = AugmentSelectionScreen.getNormalVector(from, to).normalize();
        Vector2f offset = normal.mul(1.0f);
        boolean zIndex = false;
        class_4588 buffer = context.method_51450().getBuffer(class_1921.method_51784());
        buffer.method_22918(pos, (float)from.x - offset.x, (float)from.y - offset.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)from.x + offset.x, (float)from.y + offset.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)to.x + offset.x, (float)to.y + offset.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)to.x - offset.x, (float)to.y - offset.y, (float)zIndex).method_39415(color);
        context.method_51452();
        matrices.method_22909();
    }

    private static void drawRect(class_332 context, Vector2i a, Vector2i b, Vector2i c, Vector2i d, int color) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        Matrix4f pos = matrices.method_23760().method_23761();
        boolean zIndex = false;
        class_4588 buffer = context.method_51450().getBuffer(class_1921.method_51784());
        buffer.method_22918(pos, (float)a.x, (float)a.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)b.x, (float)b.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)c.x, (float)c.y, (float)zIndex).method_39415(color);
        buffer.method_22918(pos, (float)d.x, (float)d.y, (float)zIndex).method_39415(color);
        context.method_51452();
        matrices.method_22909();
    }

    public static Vector2f getNormalVector(Vector2i point1, Vector2i point2) {
        int dx = point2.x - point1.x;
        int dy = point2.y - point1.y;
        return new Vector2f((float)(-dy), (float)dx);
    }

    private void addAugments(FlowLayout parent) {
        class_746 player = Objects.requireNonNull(this.field_22787).field_1724;
        ArrayList<Augment> augmentsToAdd = new ArrayList<Augment>();
        for (Augment augment : PlayerAugments.allAugments.values()) {
            boolean isInstalled = augment.isInstalled((class_1657)player);
            boolean isToggleable = augment.toggleable;
            if (!isInstalled || !isToggleable) continue;
            augmentsToAdd.add(augment);
        }
        int augmentCount = augmentsToAdd.size();
        int radius = 30;
        int screenSizeX = this.field_22789;
        int screenSizeY = this.field_22790;
        float sideRelative = (float)screenSizeY / (float)screenSizeX;
        for (int i = 0; i < augmentsToAdd.size(); ++i) {
            Augment augment = (Augment)augmentsToAdd.get(i);
            double angleRad = (double)((float)i / (float)augmentCount * 2.0f) * Math.PI - Math.toRadians(90.0);
            double offsetX = (double)radius * Math.cos(angleRad);
            double offsetY = (double)radius * Math.sin(angleRad);
            class_2960 id = augment.id;
            class_2960 iconTexture = Oritech.id("textures/gui/" + id.method_12832() + ".png");
            TextureComponent label = Components.texture((class_2960)iconTexture, (int)0, (int)0, (int)24, (int)24, (int)24, (int)24);
            label.positioning(Positioning.relative((int)((int)(50.0 + offsetX * (double)sideRelative)), (int)((int)(50.0 + offsetY))));
            label.sizing(Sizing.fixed((int)(screenSizeY / 12)));
            this.augments.add((Component)label);
            parent.child((Component)label);
            this.augmentIDs.put((Component)label, id);
            this.augmentSizes.put((Component)label, Float.valueOf(1.0f));
        }
        LabelComponent noOpLabel = Components.label((class_2561)class_2561.method_43470((String)"Nothing"));
        noOpLabel.positioning(Positioning.relative((int)50, (int)50));
        this.augments.add((Component)noOpLabel);
        this.noOpButton = noOpLabel;
        parent.child((Component)noOpLabel);
    }

    private void toggleAugment(class_2960 id) {
        NetworkManager.sendToServer(new PlayerAugments.AugmentPlayerTogglePacket(id));
    }

    public void method_25419() {
        if (this.lastFocused != null && this.augmentIDs.containsKey(this.lastFocused)) {
            class_2960 id = this.augmentIDs.get(this.lastFocused);
            this.toggleAugment(id);
        }
        OritechClient.activeScreen = null;
        super.method_25419();
    }
}

