/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.base.entity.UpgradableMachineBlockEntity;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.processing.FragmentForgeBlockEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.client.ui.components.BlockPreviewComponent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.MachineAddonController;

public class UpgradableMachineScreen<S extends UpgradableMachineScreenHandler>
extends BasicMachineScreen<S> {
    private static final Color SPEED_COLOR = Color.ofRgb((int)2203324);
    private static final Color EFFICIENCY_COLOR = Color.ofRgb((int)9358054);
    private static final Color CAPACITY_COLOR = Color.ofRgb((int)143431);
    private static final Color THROUGHPUT_COLOR = Color.ofRgb((int)16758531);
    private static final float rotationSpeed = 0.2f;
    private static final class_2960 MACHINE_CORE_CENTER = Oritech.id("textures/gui/modular/machine_core/center.png");
    protected LabelComponent speedLabel;
    protected LabelComponent efficiencyLabel;
    protected LabelComponent burstLabel;

    public UpgradableMachineScreen(S handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    public void addExtensionComponents(FlowLayout container) {
        super.addExtensionComponents(container);
        if (((UpgradableMachineScreenHandler)this.field_2797).addonController == null) {
            return;
        }
        MachineAddonController.BaseAddonData baseData = ((UpgradableMachineScreenHandler)this.field_2797).addonController.getBaseAddonData();
        int speed = (int)(1.0f / baseData.speed() * 100.0f);
        float efficiency = baseData.efficiency();
        int extraChambers = baseData.extraChambers();
        String burstKey = this.getBurstStatusKey();
        Object efficiencyText = "100";
        if ((double)efficiency > 1.03) {
            efficiency = (efficiency - 1.0f) * 100.0f;
            efficiency = Math.round(efficiency / 5.0f) * 5;
            efficiencyText = "-" + (int)efficiency;
        } else if ((double)efficiency < 0.97) {
            efficiency = (1.0f / efficiency - 1.0f) * 100.0f;
            efficiency = Math.round(efficiency / 5.0f) * 5;
            efficiencyText = "+" + (int)efficiency;
        }
        speed = Math.round((float)speed / 5.0f) * 5;
        this.speedLabel = Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine_speed", (Object[])new Object[]{speed}));
        this.efficiencyLabel = Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine_efficiency", (Object[])new Object[]{efficiencyText}));
        this.burstLabel = Components.label((class_2561)class_2561.method_43471((String)("title.oritech." + burstKey)));
        this.burstLabel.tooltip((class_2561)class_2561.method_43469((String)("title.oritech." + burstKey + ".tooltip"), (Object[])new Object[]{0}));
        container.child((Component)Components.box((Sizing)Sizing.fixed((int)73), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)));
        container.child(this.speedLabel.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_speed")).margins(Insets.of((int)3)));
        container.child(this.efficiencyLabel.tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_efficiency")).margins(Insets.of((int)3)));
        if (!burstKey.isBlank()) {
            container.child((Component)this.burstLabel.margins(Insets.of((int)3)));
        }
        if (extraChambers > 0) {
            container.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.chambers", (Object[])new Object[]{extraChambers})).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.chambers")).margins(Insets.of((int)3)));
        }
        if (this.steamProductionLabel != null) {
            container.child((Component)this.steamProductionLabel.margins(Insets.of((int)3)));
        }
        if (((UpgradableMachineScreenHandler)this.field_2797).blockEntity instanceof PulverizerBlockEntity || ((UpgradableMachineScreenHandler)this.field_2797).blockEntity instanceof FragmentForgeBlockEntity) {
            container.child(Components.label((class_2561)class_2561.method_43471((String)"title.oritech.machine_option_enabled")).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.pulverizer_dust_combine")).margins(Insets.of((int)3)));
        }
        if (!((MachineAddonController)((UpgradableMachineScreenHandler)this.field_2797).blockEntity).getAddonSlots().isEmpty()) {
            this.addMachinePreview(container);
        }
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        String burstKey = this.getBurstStatusKey();
        if (!burstKey.isBlank()) {
            int burstTicks = 0;
            MachineAddonController machineAddonController = ((UpgradableMachineScreenHandler)this.field_2797).addonController;
            if (machineAddonController instanceof UpgradableMachineBlockEntity) {
                UpgradableMachineBlockEntity upgradableMachineBlock = (UpgradableMachineBlockEntity)machineAddonController;
                burstTicks = upgradableMachineBlock.remainingBurstTicks;
            }
            this.burstLabel.text((class_2561)class_2561.method_43471((String)("title.oritech." + burstKey)));
            this.burstLabel.tooltip((class_2561)class_2561.method_43469((String)("title.oritech." + burstKey + ".tooltip"), (Object[])new Object[]{burstTicks}));
        }
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        int offsetX = -5;
        int offsetY = -23;
        int x = ((UpgradableMachineScreenHandler)this.field_2797).screenData.getEnergyConfiguration().x() + offsetX;
        int y = ((UpgradableMachineScreenHandler)this.field_2797).screenData.getEnergyConfiguration().y() + offsetY;
        int size = 25;
        if (((UpgradableMachineScreenHandler)this.field_2797).addonController == null) {
            return;
        }
        float level = ((UpgradableMachineScreenHandler)this.field_2797).addonController.getCoreQuality();
        float upgradeCount = level - 1.0f;
        if (upgradeCount == 6.0f) {
            overlay.child(Components.texture((class_2960)this.getRingIdentifier(6), (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)));
            upgradeCount = 5.0f;
        }
        overlay.child(Components.texture((class_2960)MACHINE_CORE_CENTER, (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)).tooltip(this.getQualityTooltip()));
        int i = 1;
        while ((float)i <= upgradeCount) {
            overlay.child(Components.texture((class_2960)this.getRingIdentifier(i), (int)64, (int)64, (int)64, (int)64, (int)64, (int)64).sizing(Sizing.fixed((int)size)).positioning(Positioning.absolute((int)x, (int)y)));
            ++i;
        }
    }

    private class_2561 getQualityTooltip() {
        String quality = String.format("%.2f", Float.valueOf(((UpgradableMachineScreenHandler)this.field_2797).addonController.getCoreQuality()));
        int effectiveQuality = (int)((UpgradableMachineScreenHandler)this.field_2797).addonController.getCoreQuality();
        return class_2561.method_43469((String)"tooltip.oritech.machine.quality", (Object[])new Object[]{effectiveQuality, quality});
    }

    private class_2960 getRingIdentifier(int level) {
        return Oritech.id("textures/gui/modular/machine_core/ring_" + level + ".png");
    }

    private String getBurstStatusKey() {
        MachineAddonController machineAddonController = ((UpgradableMachineScreenHandler)this.field_2797).addonController;
        if (machineAddonController instanceof UpgradableMachineBlockEntity) {
            UpgradableMachineBlockEntity upgradableMachineBlock = (UpgradableMachineBlockEntity)machineAddonController;
            boolean isWorking = upgradableMachineBlock.isActivelyWorking();
            boolean canBurst = upgradableMachineBlock.isBurstAvailable();
            boolean isThrottled = upgradableMachineBlock.isBurstThrottled();
            if (isThrottled) {
                return "burst.throttled";
            }
            if (isWorking && canBurst) {
                return "burst.active";
            }
            if (canBurst) {
                return "burst.ready";
            }
        }
        return "";
    }

    public void addMachinePreview(FlowLayout sidePanel) {
        FlowLayout floatingContent = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        FlowLayout holoPreviewContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)96));
        holoPreviewContainer.surface(ORITECH_PANEL);
        holoPreviewContainer.margins(Insets.of((int)2));
        FlowLayout detailsScrollPane = Containers.verticalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
        detailsScrollPane.padding(Insets.of((int)2));
        ScrollContainer detailsContainer = Containers.verticalScroll((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)110), (Component)detailsScrollPane);
        detailsContainer.surface(ORITECH_PANEL);
        detailsContainer.margins(Insets.of((int)2));
        detailsContainer.padding(Insets.of((int)4));
        floatingContent.child((Component)holoPreviewContainer);
        floatingContent.child((Component)detailsContainer);
        final int slotCount = ((UpgradableMachineScreenHandler)this.field_2797).field_7761.size();
        OverlayContainer<FlowLayout> floatingPanel = new OverlayContainer<FlowLayout>(floatingContent){

            public void remove() {
                super.remove();
                for (int i = 0; i < slotCount; ++i) {
                    UpgradableMachineScreen.this.enableSlot(i);
                }
            }
        };
        floatingPanel.zIndex(9000);
        floatingPanel.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        int previewX = 78;
        int previewY = 41;
        List<class_2338> addonBlocks = ((UpgradableMachineScreenHandler)this.field_2797).addonController.getConnectedAddons();
        for (class_2338 addonBlockPos : addonBlocks) {
            class_2680 addonBlock = ((UpgradableMachineScreenHandler)this.field_2797).worldAccess.method_8320(addonBlockPos);
            class_2586 addonBlockEntity = ((UpgradableMachineScreenHandler)this.field_2797).worldAccess.method_8321(addonBlockPos);
            class_2350 facing = (class_2350)((UpgradableMachineScreenHandler)this.field_2797).machineBlock.method_11654(((UpgradableMachineScreenHandler)this.field_2797).screenData.getBlockFacingProperty());
            class_2382 relativePos = MultiblockMachineEntity.worldToRelativePos((class_2382)((UpgradableMachineScreenHandler)this.field_2797).blockPos, (class_2382)addonBlockPos, facing);
            holoPreviewContainer.child(new BlockPreviewComponent(addonBlock, addonBlockEntity, relativePos, 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
            addonBlock = addonBlock.method_26204().method_9564();
            if (addonBlock.method_28498((class_2769)MachineAddonBlock.ADDON_USED)) {
                addonBlock = (class_2680)addonBlock.method_11657((class_2769)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(true));
            }
            MachineAddonBlock addonBlockType = (MachineAddonBlock)addonBlock.method_26204();
            MachineAddonBlock.AddonSettings addonSettings = addonBlockType.getAddonSettings();
            float speed = (1.0f - addonSettings.speedMultiplier()) * 100.0f;
            float efficiency = (1.0f - addonSettings.efficiencyMultiplier()) * 100.0f;
            int blockSize = 23;
            FlowLayout detailPane = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)2)).child(Components.block((class_2680)addonBlock).sizing(Sizing.fixed((int)blockSize)).margins(Insets.of((int)4))).child(Components.label((class_2561)addonBlock.method_26204().method_9518()).margins(Insets.of((int)5, (int)2, (int)4, (int)2)).verticalSizing(Sizing.fixed((int)15)));
            detailPane.surface(Surface.PANEL_INSET);
            FlowLayout bottomPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)2), (Sizing)Sizing.content((int)2));
            if (speed != 0.0f) {
                bottomPanel.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine_speed", (Object[])new Object[]{(int)speed})).color(SPEED_COLOR).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_speed")));
            }
            if (efficiency != 0.0f) {
                bottomPanel.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine_efficiency", (Object[])new Object[]{(int)efficiency})).color(EFFICIENCY_COLOR).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_efficiency")));
            }
            if (addonBlockType.getAddonSettings().addedCapacity() > 0L) {
                bottomPanel.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine.capacitor_added_capacity", (Object[])new Object[]{addonSettings.addedCapacity()})).color(CAPACITY_COLOR).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine.capacitor_added_capacity")));
            }
            if (addonBlockType.getAddonSettings().addedInsert() > 0L) {
                bottomPanel.child(Components.label((class_2561)class_2561.method_43469((String)"title.oritech.machine.capacitor_added_throughput", (Object[])new Object[]{addonSettings.addedInsert()})).color(THROUGHPUT_COLOR).tooltip((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine.capacitor_added_throughput")));
            }
            detailPane.child((Component)bottomPanel.positioning(Positioning.absolute((int)34, (int)18)));
            detailsScrollPane.child((Component)detailPane);
        }
        for (class_2338 openPos : ((UpgradableMachineScreenHandler)this.field_2797).addonController.getOpenAddonSlots()) {
            class_2382 relativePos = MultiblockMachineEntity.worldToRelativePos((class_2382)((UpgradableMachineScreenHandler)this.field_2797).blockPos, (class_2382)openPos, (class_2350)((UpgradableMachineScreenHandler)this.field_2797).machineBlock.method_11654(((UpgradableMachineScreenHandler)this.field_2797).screenData.getBlockFacingProperty()));
            class_2680 dummyBlock = BlockContent.ADDON_INDICATOR_BLOCK.method_9564();
            holoPreviewContainer.child(new BlockPreviewComponent(dummyBlock, null, relativePos, 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
        }
        if (addonBlocks.isEmpty()) {
            detailsScrollPane.child((Component)Components.label((class_2561)class_2561.method_43471((String)"title.oritech.machine.no_addons")));
        }
        holoPreviewContainer.child(new BlockPreviewComponent(((UpgradableMachineScreenHandler)this.field_2797).machineBlock, ((UpgradableMachineScreenHandler)this.field_2797).blockEntity, new class_2382(0, 0, 0), 0.2f).sizing(Sizing.fixed((int)20)).positioning(Positioning.absolute((int)previewX, (int)previewY)));
        ButtonComponent openAddonsButton = Components.button((class_2561)class_2561.method_43471((String)"button.oritech.machine.addons").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR), arg_0 -> this.lambda$addMachinePreview$0(floatingPanel, arg_0));
        openAddonsButton.renderer(ORITECH_BUTTON);
        openAddonsButton.textShadow(false);
        sidePanel.child((Component)openAddonsButton);
    }

    private /* synthetic */ void lambda$addMachinePreview$0(1 floatingPanel, ButtonComponent button) {
        this.root.child((Component)floatingPanel);
        for (int i = 0; i < ((UpgradableMachineScreenHandler)this.field_2797).field_7761.size(); ++i) {
            this.disableSlot(i);
        }
    }
}

