/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.fabric;

import com.google.auto.service.AutoService;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.BlockEnergyApi;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.ItemEnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.fabric.ItemStackStorage;
import rearth.oritech.util.StackContext;
import team.reborn.energy.api.EnergyStorage;

@AutoService(value={BlockEnergyApi.class, ItemEnergyApi.class})
public class FabricEnergyApiImpl
implements BlockEnergyApi,
ItemEnergyApi {
    @Override
    public void registerBlockEntity(Supplier<class_2591<?>> typeSupplier) {
        EnergyStorage.SIDED.registerForBlockEntity((entity, direction) -> ContainerStorageWrapper.of(((EnergyApi.BlockProvider)entity).getEnergyStorage((class_2350)direction)), typeSupplier.get());
    }

    @Override
    public void registerForItem(Supplier<class_1792> itemSupplier) {
        EnergyStorage.ITEM.registerForItems((stack, context) -> ContainerStorageWrapper.of(((EnergyApi.ItemProvider)stack.method_7909()).getEnergyStorage(stack), context, stack), new class_1935[]{(class_1935)itemSupplier.get()});
    }

    @Override
    public class_9331<Long> getEnergyComponent() {
        return EnergyStorage.ENERGY_COMPONENT;
    }

    @Override
    public EnergyApi.EnergyStorage find(StackContext stack) {
        if (stack.getValue().method_7947() > 1) {
            return null;
        }
        ContainerItemContext context = ContainerItemContext.ofSingleSlot((SingleSlotStorage)new ItemStackStorage(stack));
        EnergyStorage candidate = (EnergyStorage)EnergyStorage.ITEM.find(stack.getValue(), (Object)context);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            EnergyApi.EnergyStorage energyStorage = wrapper.container;
            if (energyStorage instanceof SimpleEnergyItemStorage) {
                SimpleEnergyItemStorage itemStorage = (SimpleEnergyItemStorage)energyStorage;
                return itemStorage.withCallback(ignored -> stack.sync());
            }
        }
        return new FabricStorageWrapper(candidate, stack);
    }

    @Override
    public EnergyApi.EnergyStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        EnergyStorage candidate = (EnergyStorage)EnergyStorage.SIDED.find(world, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof ContainerStorageWrapper) {
            ContainerStorageWrapper wrapper = (ContainerStorageWrapper)candidate;
            return wrapper.container;
        }
        return new FabricStorageWrapper(candidate, null);
    }

    @Override
    public EnergyApi.EnergyStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return this.find(world, pos, null, null, direction);
    }

    public static class ContainerStorageWrapper
    extends SnapshotParticipant<Long>
    implements EnergyStorage {
        public final EnergyApi.EnergyStorage container;
        @Nullable
        public final ContainerItemContext context;
        @Nullable
        public final class_1799 stack;

        public static ContainerStorageWrapper of(@Nullable EnergyApi.EnergyStorage container) {
            if (container == null) {
                return null;
            }
            return new ContainerStorageWrapper(container);
        }

        public static ContainerStorageWrapper of(@Nullable EnergyApi.EnergyStorage container, @Nullable ContainerItemContext context, @Nullable class_1799 stack) {
            if (container == null) {
                return null;
            }
            return new ContainerStorageWrapper(container, context, stack);
        }

        public ContainerStorageWrapper(EnergyApi.EnergyStorage container) {
            this.container = container;
            this.context = null;
            this.stack = null;
        }

        public ContainerStorageWrapper(EnergyApi.EnergyStorage container, @Nullable ContainerItemContext context, @Nullable class_1799 stack) {
            this.container = container;
            this.context = context;
            this.stack = stack;
        }

        public boolean supportsInsertion() {
            return this.container.supportsInsertion();
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            long inserted = this.container.insert(maxAmount, false);
            if (this.context != null) {
                this.stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), (Object)this.container.getAmount());
                this.context.exchange(ItemVariant.of((class_1799)this.stack), 1L, transaction);
            }
            return inserted;
        }

        public boolean supportsExtraction() {
            return this.container.supportsInsertion();
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((context, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            long extracted = this.container.extract(maxAmount, false);
            if (this.context != null) {
                this.stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), (Object)this.container.getAmount());
                this.context.exchange(ItemVariant.of((class_1799)this.stack), 1L, transaction);
            }
            return extracted;
        }

        public long getAmount() {
            return this.container.getAmount();
        }

        public long getCapacity() {
            return this.container.getCapacity();
        }

        protected Long createSnapshot() {
            return this.getAmount();
        }

        protected void readSnapshot(Long snapshot) {
            this.container.setAmount(snapshot);
        }
    }

    public static class FabricStorageWrapper
    extends EnergyApi.EnergyStorage {
        public final EnergyStorage storage;
        @Nullable
        public final StackContext context;

        public FabricStorageWrapper(EnergyStorage storage, @Nullable StackContext context) {
            this.storage = storage;
            this.context = context;
        }

        @Override
        public long insert(long maxAmount, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = this.storage.insert(maxAmount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = inserted;
                return l;
            }
        }

        @Override
        public long extract(long maxAmount, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                long extracted = this.storage.extract(maxAmount, (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = extracted;
                return l;
            }
        }

        @Override
        public long getAmount() {
            return this.storage.getAmount();
        }

        @Override
        public long getCapacity() {
            return this.storage.getCapacity();
        }

        @Override
        public void setAmount(long amount) {
        }

        @Override
        public void update() {
            if (this.context != null) {
                this.context.sync();
            }
        }
    }
}

