/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe;

import com.google.common.base.Optional;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;

public abstract class OritechRecipeBuilder {
    protected final OritechRecipeType type;
    protected List<Ingredient> inputs;
    protected List<ItemStack> results;
    protected FluidIngredient fluidInput;
    protected List<FluidStack> fluidOutputs;
    protected int time = 200;
    protected float timeMultiplier = 1.0f;
    protected boolean addToGrinder;
    private final String resourcePath;

    protected OritechRecipeBuilder(OritechRecipeType type, String resourcePath) {
        this.type = type;
        this.resourcePath = resourcePath;
        this.fluidOutputs = new ArrayList<FluidStack>();
    }

    public OritechRecipeBuilder input(List<Ingredient> in) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Ingredient>();
        }
        this.inputs.addAll(in);
        return this;
    }

    public OritechRecipeBuilder input(Ingredient in) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Ingredient>();
        }
        this.inputs.add(in);
        return this;
    }

    public OritechRecipeBuilder input(ItemLike in) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{in}));
    }

    public OritechRecipeBuilder input(TagKey<Item> in) {
        return this.input(Ingredient.of(in));
    }

    public OritechRecipeBuilder fluidInput(FluidIngredient in) {
        this.fluidInput = in;
        return this;
    }

    public OritechRecipeBuilder fluidInput(Fluid in, float bucketAmount) {
        return this.fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }

    public OritechRecipeBuilder specificFluidInput(Fluid in, long amountMillis) {
        return this.fluidInput(new FluidIngredient().withContent(in).withSpecificAmount(amountMillis));
    }

    public OritechRecipeBuilder fluidInput(Fluid in) {
        return this.fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(TagKey<Fluid> in) {
        return this.fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(TagKey<Fluid> in, float bucketAmount) {
        return this.fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }

    public OritechRecipeBuilder fluidOutput(FluidStack out) {
        this.fluidOutputs.add(out);
        return this;
    }

    public OritechRecipeBuilder fluidOutput(Fluid out, float bucketAmount) {
        return this.fluidOutput(FluidStack.create((Fluid)out, (long)((long)(bucketAmount * (float)FluidStackHooks.bucketAmount()))));
    }

    public OritechRecipeBuilder fluidOutput(Fluid out) {
        return this.fluidOutput(FluidStack.create((Fluid)out, (long)FluidStackHooks.bucketAmount()));
    }

    public OritechRecipeBuilder result(ItemStack out) {
        if (this.results == null) {
            this.results = new ArrayList<ItemStack>();
        }
        this.results.add(out);
        return this;
    }

    public OritechRecipeBuilder result(List<ItemStack> out) {
        if (this.results == null) {
            this.results = new ArrayList<ItemStack>();
        }
        this.results.addAll(out);
        return this;
    }

    public OritechRecipeBuilder result(Item out, int count) {
        return this.result(new ItemStack((ItemLike)out, count));
    }

    public OritechRecipeBuilder result(Item out) {
        return this.result(out, 1);
    }

    public OritechRecipeBuilder result(Optional<Item> out, int count) {
        if (out.isPresent()) {
            return this.result((Item)out.get(), count);
        }
        return this;
    }

    public OritechRecipeBuilder result(Optional<Item> out) {
        return this.result(out, 1);
    }

    public OritechRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public OritechRecipeBuilder timeInSeconds(int time) {
        return this.time(time * 20);
    }

    public OritechRecipeBuilder timeMultiplier(float timeMultiplier) {
        this.timeMultiplier = timeMultiplier;
        return this;
    }

    public OritechRecipeBuilder addToGrinder() {
        this.addToGrinder = true;
        return this;
    }

    public abstract void validate(ResourceLocation var1) throws IllegalStateException;

    public void export(RecipeOutput exporter, String suffix, String namespace) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(this.resourcePath + "/" + suffix));
        this.validate(id);
        exporter.accept(id, (Recipe)new OritechRecipe((int)((float)this.time * this.timeMultiplier), this.inputs != null ? this.inputs : List.of(), this.results != null ? this.results : List.of(), this.type, this.fluidInput != null ? this.fluidInput : FluidIngredient.EMPTY, this.fluidOutputs != null ? this.fluidOutputs : List.of()), null);
    }

    public void export(RecipeOutput exporter, String suffix) {
        this.export(exporter, suffix, "oritech");
    }
}

