/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.decorative;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;

public class MetalGirderBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty HEADING = BooleanProperty.create((String)"heading");
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);

    public MetalGirderBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HEADING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEADING});
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (facing.getAxis().equals((Object)Direction.Axis.X)) {
            return NORTH_SHAPE;
        }
        return EAST_SHAPE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getCollisionShape(state, world, pos, context);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean blockInBack = world.getBlockState(pos.offset(facing.getNormal())).is(BlockContent.METAL_GIRDER_BLOCK);
        boolean blockInFront = world.getBlockState(pos.offset(facing.getOpposite().getNormal())).is(BlockContent.METAL_GIRDER_BLOCK);
        boolean straight = false;
        if (blockInFront && !blockInBack) {
            facing = facing.getOpposite();
        } else if (blockInFront && blockInBack) {
            straight = true;
        }
        return (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)HEADING, (Comparable)Boolean.valueOf(!straight));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction facing = ctx.getClickedFace();
        if (ctx.getClickedFace().getAxis().equals((Object)Direction.Axis.Y)) {
            facing = ctx.getHorizontalDirection().getOpposite();
        }
        boolean blockInBack = world.getBlockState(pos.offset(facing.getNormal())).is(BlockContent.METAL_GIRDER_BLOCK);
        boolean blockInFront = world.getBlockState(pos.offset(facing.getOpposite().getNormal())).is(BlockContent.METAL_GIRDER_BLOCK);
        boolean straight = false;
        if (blockInFront && !blockInBack) {
            facing = facing.getOpposite();
        } else if (blockInFront && blockInBack) {
            straight = true;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)HEADING, (Comparable)Boolean.valueOf(!straight));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }
}

