/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

public class EnergyAcceptorAddonBlockEntity
extends AddonBlockEntity
implements EnergyApi.BlockProvider {
    private final DelegatingEnergyStorage delegatedStorage = new DelegatingEnergyStorage(this::getMainStorage, this::isConnected);
    private MachineAddonController cachedController;

    public EnergyAcceptorAddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ENERGY_ACCEPTOR_ADDON_ENTITY, pos, state);
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    private EnergyApi.EnergyStorage getMainStorage() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        if (!isUsed.booleanValue()) {
            return null;
        }
        MachineAddonController controllerEntity = this.getCachedController();
        return controllerEntity.getStorageForAddon();
    }

    private MachineAddonController getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        this.cachedController = (MachineAddonController)Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
        return this.cachedController;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.delegatedStorage;
    }
}

