/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;

public class FuelGeneratorEntity
extends FluidMultiblockGeneratorBlockEntity {
    public FuelGeneratorEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.FUEL_GENERATOR_ENTITY, pos, state, Oritech.CONFIG.generators.fuelGeneratorData.energyPerTick());
    }

    @Override
    protected Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos pos, Level world) {
        Vec3i posA = new Vec3i(1, 0, -1);
        Vec3i corePosA = new Vec3i(0, 0, -1);
        Vec3i posB = new Vec3i(1, 0, 1);
        Direction facing = this.getFacingForAddon();
        BlockPos worldPosA = (BlockPos)Geometry.offsetToWorldPosition(facing, posA, (Vec3i)pos);
        BlockPos coreWorldPosA = (BlockPos)Geometry.offsetToWorldPosition(facing, corePosA, (Vec3i)pos);
        BlockPos worldPosB = (BlockPos)Geometry.offsetToWorldPosition(facing, posB, (Vec3i)pos);
        BlockPos offset = worldPosA.subtract((Vec3i)coreWorldPosA);
        Direction direction = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        res.add(new Tuple((Object)worldPosA, (Object)direction));
        res.add(new Tuple((Object)worldPosB, (Object)direction));
        return res;
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.FUEL_GENERATOR;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.FUEL_GENERATOR_SCREEN;
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.fuelGeneratorData.maxEnergyExtraction();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.fuelGeneratorData.energyCapacity();
    }

    @Override
    protected float getAnimationSpeed() {
        return super.getAnimationSpeed() / 3.0f;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(1, 0, 0), new Vec3i(-3, 0, 0));
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, 0), new Vec3i(-2, 0, -1), new Vec3i(0, 1, 1), new Vec3i(0, 1, 0), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, -1), new Vec3i(-2, 1, 1), new Vec3i(-2, 1, 0), new Vec3i(-2, 1, -1));
    }
}

