/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.client.renderers.MachineModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class MachineRenderer<T extends BlockEntity>
extends GeoBlockRenderer<T> {
    public MachineRenderer(String modelPath) {
        super(new MachineModel(modelPath));
    }

    public MachineRenderer(String modelPath, boolean glowing) {
        super(new MachineModel(modelPath));
        if (glowing) {
            this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        }
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        if (facing.equals((Object)Direction.UP)) {
            poseStack.translate(0.0, 0.5, -0.5);
        } else if (facing.equals((Object)Direction.DOWN)) {
            poseStack.translate(0.0, 0.5, 0.5);
        }
        super.rotateBlock(facing, poseStack);
    }

    public AABB getRenderBoundingBox(BlockEntity blockEntity) {
        return AABB.ofSize((Vec3)blockEntity.getBlockPos().getCenter(), (double)4.0, (double)4.0, (double)4.0);
    }
}

