/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.neoforge;

import com.google.auto.service.AutoService;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.BlockFluidApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;
import rearth.oritech.util.StackContext;

@AutoService(value={BlockFluidApi.class, ItemFluidApi.class})
public class NeoforgeFluidApiImpl
implements BlockFluidApi,
ItemFluidApi {
    private final List<Supplier<BlockEntityType<?>>> registeredBlockEntities = new ArrayList();
    private final List<Supplier<Item>> registeredItems = new ArrayList<Supplier<Item>>();

    @Override
    public void registerBlockEntity(Supplier<BlockEntityType<?>> typeSupplier) {
        this.registeredBlockEntities.add(typeSupplier);
    }

    public void registerEvent(RegisterCapabilitiesEvent event) {
        for (Supplier<BlockEntityType<?>> supplier : this.registeredBlockEntities) {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, supplier.get(), (entity, direction) -> {
                FluidApi.FluidStorage storage = ((FluidApi.BlockProvider)entity).getFluidStorage((Direction)direction);
                if (storage == null) {
                    return null;
                }
                if (storage instanceof FluidApi.MultiSlotStorage) {
                    FluidApi.MultiSlotStorage inOutContainer = (FluidApi.MultiSlotStorage)storage;
                    return MultiSlotStorageWrapper.of(inOutContainer);
                }
                if (storage instanceof FluidApi.SingleSlotStorage) {
                    FluidApi.SingleSlotStorage singleContainer = (FluidApi.SingleSlotStorage)storage;
                    return SingleSlotContainerStorageWrapper.of(singleContainer);
                }
                if (storage instanceof DelegatingFluidStorage) {
                    DelegatingFluidStorage delegatingFluidStorage = (DelegatingFluidStorage)storage;
                    return new DelegatingContainerStorageWrapper(delegatingFluidStorage);
                }
                Oritech.LOGGER.error("Error during fluid provider registration, unable to register a fluid container");
                Oritech.LOGGER.error("Erroring container type is: {}", entity);
                return null;
            });
        }
        for (Supplier<BlockEntityType<?>> supplier : this.registeredItems) {
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ignored) -> FluidContainerItemWrapper.of(((FluidApi.ItemProvider)stack.getItem()).getFluidStorage((ItemStack)stack), stack), new ItemLike[]{(ItemLike)supplier.get()});
        }
    }

    @Override
    public void registerForItem(Supplier<Item> itemSupplier) {
        this.registeredItems.add(itemSupplier);
    }

    @Override
    public FluidApi.FluidStorage find(Level world, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        IFluidHandler candidate;
        IFluidHandler iFluidHandler = candidate = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos, state, entity, (Object)direction);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleSlotContainerStorageWrapper.class, MultiSlotStorageWrapper.class}, (Object)iFluidHandler, n)) {
            case -1 -> null;
            case 0 -> {
                SingleSlotContainerStorageWrapper wrapper = (SingleSlotContainerStorageWrapper)iFluidHandler;
                yield wrapper.container;
            }
            case 1 -> {
                MultiSlotStorageWrapper wrapper = (MultiSlotStorageWrapper)iFluidHandler;
                yield wrapper.container;
            }
            default -> new NeoforgeStorageWrapper(candidate);
        };
    }

    @Override
    public FluidApi.FluidStorage find(Level world, BlockPos pos, @Nullable Direction direction) {
        return this.find(world, pos, null, null, direction);
    }

    @Override
    public FluidApi.FluidStorage find(StackContext stack) {
        if (stack.getValue().getCount() > 1) {
            return null;
        }
        IFluidHandlerItem candidate = (IFluidHandlerItem)stack.getValue().getCapability(Capabilities.FluidHandler.ITEM);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof SingleSlotContainerStorageWrapper) {
            SingleSlotContainerStorageWrapper wrapper = (SingleSlotContainerStorageWrapper)candidate;
            FluidApi.SingleSlotStorage singleSlotStorage = wrapper.container;
            if (singleSlotStorage instanceof SimpleItemFluidStorage) {
                SimpleItemFluidStorage itemContainer = (SimpleItemFluidStorage)singleSlotStorage;
                return itemContainer.withCallback(ignored -> stack.sync());
            }
        }
        return new NeoforgeItemStorageWrapper(candidate, stack);
    }

    public static class SingleSlotContainerStorageWrapper
    implements IFluidHandler {
        public final FluidApi.SingleSlotStorage container;

        public static SingleSlotContainerStorageWrapper of(@Nullable FluidApi.SingleSlotStorage container) {
            if (container == null) {
                return null;
            }
            return new SingleSlotContainerStorageWrapper(container);
        }

        public SingleSlotContainerStorageWrapper(FluidApi.SingleSlotStorage container) {
            this.container = container;
        }

        public int getTanks() {
            return 1;
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack getFluidInTank(int i) {
            return FluidStackHooksForge.toForge((FluidStack)this.container.getStack());
        }

        public int getTankCapacity(int i) {
            return (int)this.container.getCapacity();
        }

        public boolean isFluidValid(int i, @NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack) {
            return true;
        }

        public int fill(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
            int result = (int)this.container.insert(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (result > 0 && fluidAction.execute()) {
                this.container.update();
            }
            return result;
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
            long extractedAmount = this.container.extract(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(fluidStack.getFluid(), (int)extractedAmount);
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(int i, @NotNull IFluidHandler.FluidAction fluidAction) {
            long extractedAmount = this.container.extract(this.container.getStack().copyWithAmount((long)i), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(this.container.getStack().getFluid(), (int)extractedAmount);
        }
    }

    public static class MultiSlotStorageWrapper
    implements IFluidHandler {
        public final FluidApi.MultiSlotStorage container;

        public static MultiSlotStorageWrapper of(FluidApi.MultiSlotStorage container) {
            if (container == null) {
                return null;
            }
            return new MultiSlotStorageWrapper(container);
        }

        public MultiSlotStorageWrapper(FluidApi.MultiSlotStorage container) {
            this.container = container;
        }

        public int getTanks() {
            return this.container.getSlotCount();
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack getFluidInTank(int i) {
            return FluidStackHooksForge.toForge((FluidStack)this.container.getStack(i));
        }

        public int getTankCapacity(int i) {
            return (int)this.container.getCapacity();
        }

        public boolean isFluidValid(int i, @NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack) {
            return true;
        }

        public int fill(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            int result = (int)this.container.insert(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (result > 0 && fluidAction.execute()) {
                this.container.update();
            }
            return result;
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
            long extractedAmount = this.container.extract(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(fluidStack.getFluid(), (int)extractedAmount);
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(int i, @NotNull IFluidHandler.FluidAction fluidAction) {
            long extractedAmount = this.container.extract(this.container.getStack(i).copyWithAmount((long)i), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(this.container.getStack(i).getFluid(), (int)extractedAmount);
        }
    }

    public static class NeoforgeStorageWrapper
    extends FluidApi.FluidStorage {
        private final IFluidHandler storage;

        public NeoforgeStorageWrapper(IFluidHandler storage) {
            this.storage = storage;
        }

        @Override
        public long insert(FluidStack toInsert, boolean simulate) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            return this.storage.fill(FluidStackHooksForge.toForge((FluidStack)toInsert), action);
        }

        @Override
        public long extract(FluidStack toExtract, boolean simulate) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            return this.storage.drain(FluidStackHooksForge.toForge((FluidStack)toExtract), action).getAmount();
        }

        @Override
        public List<FluidStack> getContent() {
            ArrayList<FluidStack> content = new ArrayList<FluidStack>();
            for (int i = 0; i < this.storage.getTanks(); ++i) {
                net.neoforged.neoforge.fluids.FluidStack tank = this.storage.getFluidInTank(i);
                content.add(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)tank));
            }
            return content;
        }

        @Override
        public void update() {
        }

        @Override
        public long getCapacity() {
            Oritech.LOGGER.warn("tried to access capacity of external container");
            return 0L;
        }
    }

    public static class NeoforgeItemStorageWrapper
    extends NeoforgeStorageWrapper {
        private final StackContext stack;
        private final IFluidHandlerItem handler;

        public NeoforgeItemStorageWrapper(IFluidHandlerItem storage, StackContext stack) {
            super((IFluidHandler)storage);
            this.stack = stack;
            this.handler = storage;
        }

        @Override
        public void update() {
            super.update();
            this.stack.setValue(this.handler.getContainer());
            this.stack.sync();
        }
    }

    public static class FluidContainerItemWrapper
    extends SingleSlotContainerStorageWrapper
    implements IFluidHandlerItem {
        private final ItemStack stack;

        public static FluidContainerItemWrapper of(FluidApi.SingleSlotStorage container, ItemStack stack) {
            if (container == null || stack == null || stack.isEmpty()) {
                return null;
            }
            return new FluidContainerItemWrapper(container, stack);
        }

        public FluidContainerItemWrapper(FluidApi.SingleSlotStorage container, ItemStack stack) {
            super(container);
            this.stack = stack;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }
    }

    public static class DelegatingContainerStorageWrapper
    implements IFluidHandler {
        private final DelegatingFluidStorage container;

        public static DelegatingContainerStorageWrapper of(DelegatingFluidStorage container) {
            if (container == null) {
                return null;
            }
            return new DelegatingContainerStorageWrapper(container);
        }

        private DelegatingContainerStorageWrapper(DelegatingFluidStorage container) {
            this.container = container;
        }

        public int getTanks() {
            return this.container.getContent().size();
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack getFluidInTank(int i) {
            return FluidStackHooksForge.toForge((FluidStack)this.container.getContent().get(i));
        }

        public int getTankCapacity(int i) {
            return (int)this.container.getCapacity();
        }

        public boolean isFluidValid(int i, @NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack) {
            return true;
        }

        public int fill(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            int result = (int)this.container.insert(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (result > 0 && fluidAction.execute()) {
                this.container.update();
            }
            return result;
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(@NotNull net.neoforged.neoforge.fluids.FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
            long extractedAmount = this.container.extract(FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(fluidStack.getFluid(), (int)extractedAmount);
        }

        public @NotNull net.neoforged.neoforge.fluids.FluidStack drain(int i, @NotNull IFluidHandler.FluidAction fluidAction) {
            if (this.container.getContent() == null || this.container.getContent().isEmpty()) {
                return net.neoforged.neoforge.fluids.FluidStack.EMPTY;
            }
            long extractedAmount = this.container.extract(this.container.getContent().getLast().copyWithAmount((long)i), fluidAction.simulate());
            if (extractedAmount > 0L && fluidAction.execute()) {
                this.container.update();
            }
            return new net.neoforged.neoforge.fluids.FluidStack(this.container.getContent().getLast().getFluid(), (int)extractedAmount);
        }
    }
}

