/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.ScreenProvider;

public interface MachineAddonController {
    public List<BlockPos> getConnectedAddons();

    public List<BlockPos> getOpenAddonSlots();

    public BlockPos getPosForAddon();

    public Level getWorldForAddon();

    public Direction getFacingForAddon();

    public DynamicEnergyStorage getStorageForAddon();

    public ItemApi.InventoryStorage getInventoryForAddon();

    public ScreenProvider getScreenProvider();

    public List<Vec3i> getAddonSlots();

    public BaseAddonData getBaseAddonData();

    public void setBaseAddonData(BaseAddonData var1);

    public long getDefaultCapacity();

    public long getDefaultInsertRate();

    default public float getCoreQuality() {
        return 1.0f;
    }

    default public void initAddons(BlockPos brokenAddon) {
        List<AddonBlock> foundAddons = this.getAllAddons(brokenAddon);
        this.gatherAddonStats(foundAddons);
        this.writeAddons(foundAddons);
        this.updateEnergyContainer();
        this.removeOldAddons(foundAddons);
        this.getConnectedAddons().clear();
        this.updateEnergyContainer();
        for (AddonBlock addon : foundAddons) {
            this.getConnectedAddons().add(addon.pos());
        }
    }

    private void removeOldAddons(List<AddonBlock> foundAddons) {
        for (BlockPos addon : this.getConnectedAddons()) {
            BlockState state;
            if (!foundAddons.stream().noneMatch(newAddon -> newAddon.pos().equals((Object)addon)) || !((state = Objects.requireNonNull(this.getWorldForAddon()).getBlockState(addon)).getBlock() instanceof MachineAddonBlock)) continue;
            this.getWorldForAddon().setBlockAndUpdate(addon, (BlockState)state.setValue((Property)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(false)));
            this.getWorldForAddon().updateNeighborsAt(addon, state.getBlock());
        }
    }

    default public void initAddons() {
        this.initAddons(null);
    }

    default public void resetAddons() {
        for (BlockPos addon : this.getConnectedAddons()) {
            BlockState state = Objects.requireNonNull(this.getWorldForAddon()).getBlockState(addon);
            if (!(state.getBlock() instanceof MachineAddonBlock)) continue;
            this.getWorldForAddon().setBlockAndUpdate(addon, (BlockState)state.setValue((Property)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(false)));
            this.getWorldForAddon().updateNeighborsAt(addon, state.getBlock());
        }
        this.getConnectedAddons().clear();
        this.updateEnergyContainer();
    }

    default public List<AddonBlock> getAllAddons(BlockPos brokenAddon) {
        boolean useLayered = Oritech.CONFIG.layeredExtenders();
        int maxIterationCount = (int)this.getCoreQuality() + 1;
        Level world = this.getWorldForAddon();
        BlockPos pos = this.getPosForAddon();
        if (!1.$assertionsDisabled && world == null) {
            throw new AssertionError();
        }
        List<BlockPos> openSlots = this.getOpenAddonSlots();
        openSlots.clear();
        int foundExtenders = 0;
        List<Vec3i> baseSlots = this.getAddonSlots();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>(baseSlots.size());
        ArrayList<Object> queuedPositions = new ArrayList<Object>(baseSlots.size());
        ArrayList<AddonBlock> result = new ArrayList<AddonBlock>(baseSlots.size());
        for (Vec3i initialSpot : baseSlots) {
            queuedPositions.add((BlockPos)Geometry.offsetToWorldPosition(this.getFacingForAddon(), initialSpot, (Vec3i)pos));
        }
        HashSet<BlockPos> toAdd = new HashSet<BlockPos>();
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (int i = 0; i < maxIterationCount && !queuedPositions.isEmpty(); ++i) {
            for (BlockPos blockPos : queuedPositions) {
                MachineAddonBlock addonBlock;
                BlockEntity candidateEntity;
                BlockState candidate;
                block13: {
                    block12: {
                        if (searchedPositions.contains(blockPos)) continue;
                        searchedPositions.add(blockPos);
                        toRemove.add(blockPos);
                        candidate = world.getBlockState(blockPos);
                        candidateEntity = world.getBlockEntity(blockPos);
                        if (blockPos.equals((Object)brokenAddon)) {
                            openSlots.add(blockPos);
                            continue;
                        }
                        Block block = candidate.getBlock();
                        if (!(block instanceof MachineAddonBlock)) break block12;
                        addonBlock = (MachineAddonBlock)block;
                        if (candidateEntity instanceof AddonBlockEntity) break block13;
                    }
                    if (blockPos.equals((Object)pos)) continue;
                    openSlots.add(blockPos);
                    continue;
                }
                AddonBlockEntity candidateAddonEntity = (AddonBlockEntity)candidateEntity;
                if (((Boolean)candidate.getValue((Property)MachineAddonBlock.ADDON_USED)).booleanValue() && !candidateAddonEntity.getControllerPos().equals((Object)pos)) {
                    openSlots.add(blockPos);
                    continue;
                }
                if (addonBlock.getAddonSettings().extender() && !useLayered) {
                    if (foundExtenders >= maxIterationCount - 1) continue;
                    ++foundExtenders;
                }
                AddonBlock entry = new AddonBlock(addonBlock, candidate, blockPos, candidateAddonEntity);
                result.add(entry);
                if (addonBlock.getAddonSettings().extender()) {
                    Set<BlockPos> neighbors = MachineAddonController.getNeighbors(blockPos);
                    for (BlockPos neighbor : neighbors) {
                        if (searchedPositions.contains(neighbor)) continue;
                        toAdd.add(neighbor);
                    }
                }
                if (!(entry.addonEntity() instanceof CombiAddonEntity)) continue;
                toAdd.clear();
                maxIterationCount = 0;
                break;
            }
            queuedPositions.addAll(toAdd);
            queuedPositions.removeAll(toRemove);
            toAdd.clear();
            toRemove.clear();
        }
        return result;
    }

    default public void gatherAddonStats(List<AddonBlock> addons) {
        AddonBlockEntity addonBlockEntity;
        if (addons.size() == 1 && (addonBlockEntity = addons.getFirst().addonEntity()) instanceof CombiAddonEntity) {
            CombiAddonEntity combiAddonEntity = (CombiAddonEntity)addonBlockEntity;
            this.getAdditionalStatFromAddon(addons.getFirst());
            this.setBaseAddonData(combiAddonEntity.getBaseData());
            return;
        }
        float speed = 1.0f;
        float efficiency = 1.0f;
        long energyAmount = 0L;
        long energyInsert = 0L;
        int extraChambers = 0;
        int extraBurstTicks = 0;
        for (AddonBlock addon : addons) {
            MachineAddonBlock.AddonSettings addonSettings = addon.addonBlock().getAddonSettings();
            if (Oritech.CONFIG.additiveAddons()) {
                speed += 1.0f - addonSettings.speedMultiplier();
                efficiency += 1.0f - addonSettings.efficiencyMultiplier();
            } else {
                speed *= addonSettings.speedMultiplier();
                efficiency *= addonSettings.efficiencyMultiplier();
            }
            energyAmount += addonSettings.addedCapacity();
            energyInsert += addonSettings.addedInsert();
            extraChambers += addonSettings.chamberCount();
            extraBurstTicks += addonSettings.burstTicks();
            this.getAdditionalStatFromAddon(addon);
        }
        if (Oritech.CONFIG.additiveAddons()) {
            speed = 1.0f / speed;
            float efficiencyChange = efficiency - 1.0f;
            efficiency = 1.0f / efficiency;
            if (efficiencyChange < 0.0f) {
                efficiency = 1.0f + Math.abs(efficiencyChange);
            }
        }
        BaseAddonData baseData = new BaseAddonData(speed, efficiency, energyAmount, energyInsert, extraChambers, extraBurstTicks);
        this.setBaseAddonData(baseData);
    }

    default public void getAdditionalStatFromAddon(AddonBlock addonBlock) {
    }

    default public void writeAddons(List<AddonBlock> addons) {
        Level world = this.getWorldForAddon();
        BlockPos pos = this.getPosForAddon();
        if (!1.$assertionsDisabled && world == null) {
            throw new AssertionError();
        }
        for (AddonBlock addon : addons) {
            BlockState newState = (BlockState)addon.state().setValue((Property)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(true));
            addon.addonEntity().setControllerPos(pos);
            world.setBlockAndUpdate(addon.pos(), newState);
        }
    }

    default public void updateEnergyContainer() {
        DynamicEnergyStorage energyStorage = this.getStorageForAddon();
        BaseAddonData addonData = this.getBaseAddonData();
        energyStorage.capacity = this.getDefaultCapacity() + addonData.energyBonusCapacity;
        energyStorage.maxInsert = this.getDefaultInsertRate() + addonData.energyBonusTransfer;
        energyStorage.amount = Math.min(energyStorage.amount, energyStorage.capacity);
    }

    default public void writeAddonToNbt(CompoundTag nbt) {
        BaseAddonData data = this.getBaseAddonData();
        nbt.putFloat("speed", data.speed);
        nbt.putFloat("efficiency", data.efficiency);
        nbt.putLong("energyBonusCapacity", data.energyBonusCapacity);
        nbt.putLong("energyBonusTransfer", data.energyBonusTransfer);
        nbt.putInt("extraChambers", data.extraChambers);
        nbt.putInt("maxBurst", data.maxBurstTicks);
        ListTag posList = new ListTag();
        for (BlockPos pos : this.getConnectedAddons()) {
            CompoundTag posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            posList.add((Object)posTag);
        }
        nbt.put("connectedAddons", (Tag)posList);
    }

    default public void loadAddonNbtData(CompoundTag nbt) {
        BaseAddonData data = new BaseAddonData(nbt.getFloat("speed"), nbt.getFloat("efficiency"), nbt.getLong("energyBonusCapacity"), nbt.getLong("energyBonusTransfer"), nbt.getInt("extraChambers"), nbt.getInt("maxBurst"));
        this.setBaseAddonData(data);
        ListTag posList = nbt.getList("connectedAddons", 10);
        List<BlockPos> connectedAddons = this.getConnectedAddons();
        for (Tag posTag : posList) {
            CompoundTag posCompound = (CompoundTag)posTag;
            int x = posCompound.getInt("x");
            int y = posCompound.getInt("y");
            int z = posCompound.getInt("z");
            BlockPos pos = new BlockPos(x, y, z);
            connectedAddons.add(pos);
        }
    }

    private static Set<BlockPos> getNeighbors(BlockPos pos) {
        return Set.of(pos.offset(-1, 0, 0), pos.offset(1, 0, 0), pos.offset(0, 0, -1), pos.offset(0, 0, 1), pos.offset(0, -1, 0), pos.offset(0, 1, 0));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public record AddonBlock(MachineAddonBlock addonBlock, BlockState state, BlockPos pos, AddonBlockEntity addonEntity) {
    }

    public record BaseAddonData(float speed, float efficiency, long energyBonusCapacity, long energyBonusTransfer, int extraChambers, int maxBurstTicks) {
        public static final Codec<BaseAddonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(BaseAddonData::speed), (App)Codec.FLOAT.fieldOf("efficiency").forGetter(BaseAddonData::efficiency), (App)Codec.LONG.fieldOf("energy_bonus_capacity").forGetter(BaseAddonData::energyBonusCapacity), (App)Codec.LONG.fieldOf("energy_bonus_transfer").forGetter(BaseAddonData::energyBonusTransfer), (App)Codec.INT.fieldOf("extra_chambers").forGetter(BaseAddonData::extraChambers), (App)Codec.INT.fieldOf("max_burst_ticks").forGetter(BaseAddonData::maxBurstTicks)).apply((Applicative)instance, BaseAddonData::new));
        public static final BaseAddonData DEFAULT_ADDON_DATA = new BaseAddonData(1.0f, 1.0f, 0L, 0L, 0, 0);
    }
}

