/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.addons;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

public class CombiAddonBlock
extends MachineAddonBlock {
    public CombiAddonBlock(BlockBehaviour.Properties settings, MachineAddonBlock.AddonSettings addonSettings) {
        super(settings, addonSettings);
    }

    @Override
    @NotNull
    public Class<? extends BlockEntity> getBlockEntityType() {
        return CombiAddonEntity.class;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide() && itemStack.has((DataComponentType)ComponentContent.ADDON_DATA.get()) && (blockEntity = world.getBlockEntity(pos)) instanceof CombiAddonEntity) {
            CombiAddonEntity combiAddonEntity = (CombiAddonEntity)blockEntity;
            combiAddonEntity.storedData = (ShrinkerBlockEntity.ShrunkAddonData)itemStack.get((DataComponentType)ComponentContent.ADDON_DATA.get());
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        boolean showExtra = Screen.hasControlDown();
        if (showExtra) {
            if (!stack.has((DataComponentType)ComponentContent.ADDON_DATA.get())) {
                return;
            }
            ShrinkerBlockEntity.ShrunkAddonData data = (ShrinkerBlockEntity.ShrunkAddonData)stack.get((DataComponentType)ComponentContent.ADDON_DATA.get());
            ArrayList<Component> foundTexts = CombiAddonBlock.getShrinkTooltip(data);
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.combi_addon_desc").withStyle(ChatFormatting.GRAY));
            tooltip.addAll(foundTexts);
        }
    }

    @NotNull
    public static ArrayList<Component> getShrinkTooltip(ShrinkerBlockEntity.ShrunkAddonData data) {
        int displayedNumber;
        MachineAddonController.BaseAddonData usedSettings = data.data();
        ArrayList<Component> foundTexts = new ArrayList<Component>();
        if (usedSettings.speed() != 1.0f) {
            displayedNumber = Math.round((1.0f / usedSettings.speed() - 1.0f) * 100.0f);
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_speed_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        if (usedSettings.efficiency() != 1.0f) {
            displayedNumber = Math.round((1.0f - usedSettings.efficiency()) * 100.0f);
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_efficiency_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
        }
        if (usedSettings.energyBonusCapacity() != 0L) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_capacity_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusCapacity(), " RF")));
        }
        if (usedSettings.energyBonusTransfer() != 0L) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_transfer_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip(usedSettings.energyBonusTransfer(), " RF/t")));
        }
        if (usedSettings.maxBurstTicks() != 0) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_burst", (Object[])new Object[]{usedSettings.maxBurstTicks()}).withStyle(ChatFormatting.GRAY));
        }
        if (data.cropFilter()) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_crop").withStyle(ChatFormatting.GRAY));
        }
        if (data.fluid()) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_fluid").withStyle(ChatFormatting.GRAY));
        }
        if (data.quarryCount() > 0) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_quarry", (Object[])new Object[]{data.quarryCount()}).withStyle(ChatFormatting.GRAY));
        }
        if (data.yieldCount() > 0) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_yield", (Object[])new Object[]{data.yieldCount()}).withStyle(ChatFormatting.GRAY));
        }
        if (data.silk()) {
            foundTexts.add((Component)Component.translatable((String)"tooltip.oritech.addon_combi_silk").withStyle(ChatFormatting.GRAY));
        }
        return foundTexts;
    }
}

