/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import rearth.oritech.api.recipe.AtomicForgeRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeFluidRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeRecipeBuilder;
import rearth.oritech.api.recipe.FoundryRecipeBuilder;
import rearth.oritech.api.recipe.GrinderRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeGenerator;
import rearth.oritech.api.recipe.PulverizerRecipeBuilder;
import rearth.oritech.api.recipe.RefineryRecipeBuilder;
import rearth.oritech.api.recipe.util.RecipeHelpers;
import rearth.oritech.init.FluidContent;

public class MetalProcessingChainBuilder {
    private String metalName;
    private String resourcePath = "";
    private class_1856 ore;
    private class_1856 rawOreIngredient;
    private class_1792 rawOreItem;
    private class_1792 rawOreByproduct;
    private class_1856 ingotIngredient;
    private class_1792 ingotItem;
    private class_1856 nuggetIngredient;
    private class_1792 nuggetItem;
    private class_1856 clumpIngredient;
    private class_1792 clumpItem;
    private class_1792 smallClumpItem;
    private class_1792 dustItem;
    private class_1792 smallDustItem;
    private class_1792 centrifugeResult;
    private int centrifugeAmount;
    private class_1792 dustByproduct;
    private class_1792 clumpByproduct;
    private int byproductAmount = 3;
    private class_1856 gemIngredient;
    private class_1792 gemItem;
    private class_1856 gemCatalyst;
    private float timeMultiplier = 1.0f;
    private boolean vanillaProcessing = false;
    private boolean skipCompactingRecipes = false;

    private MetalProcessingChainBuilder(String metalName) {
        this.metalName = metalName;
    }

    public static MetalProcessingChainBuilder build(String metalName) {
        return new MetalProcessingChainBuilder(metalName);
    }

    public MetalProcessingChainBuilder resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public MetalProcessingChainBuilder ore(class_1856 ore) {
        this.ore = ore;
        return this;
    }

    public MetalProcessingChainBuilder ore(class_6862<class_1792> oreTag) {
        return this.ore(class_1856.method_8106(oreTag));
    }

    public MetalProcessingChainBuilder ore(class_1935 ore) {
        return this.ore(class_1856.method_8091((class_1935[])new class_1935[]{ore}));
    }

    public MetalProcessingChainBuilder rawOre(class_1856 rawOreIngredient, class_1792 rawOre) {
        this.rawOreIngredient = rawOreIngredient;
        this.rawOreItem = rawOre;
        return this;
    }

    public MetalProcessingChainBuilder rawOre(class_6862<class_1792> rawOreTag, class_1792 rawOre) {
        return this.rawOre(class_1856.method_8106(rawOreTag), rawOre);
    }

    public MetalProcessingChainBuilder rawOre(class_1792 rawOre) {
        return this.rawOre(class_1856.method_8091((class_1935[])new class_1935[]{rawOre}), rawOre);
    }

    public MetalProcessingChainBuilder rawOreByproduct(class_1792 byproduct) {
        this.rawOreByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder ingot(class_1856 ingotIngredient, class_1792 ingot) {
        this.ingotIngredient = ingotIngredient;
        this.ingotItem = ingot;
        return this;
    }

    public MetalProcessingChainBuilder ingot(class_6862<class_1792> ingotTag, class_1792 ingot) {
        return this.ingot(class_1856.method_8106(ingotTag), ingot);
    }

    public MetalProcessingChainBuilder ingot(class_1792 ingot) {
        return this.ingot(class_1856.method_8091((class_1935[])new class_1935[]{ingot}), ingot);
    }

    public MetalProcessingChainBuilder nugget(class_1856 nuggetIngredient, class_1792 nugget) {
        this.nuggetIngredient = nuggetIngredient;
        this.nuggetItem = nugget;
        return this;
    }

    public MetalProcessingChainBuilder nugget(class_6862<class_1792> nuggetTag, class_1792 nugget) {
        return this.nugget(class_1856.method_8106(nuggetTag), nugget);
    }

    public MetalProcessingChainBuilder nugget(class_1792 nugget) {
        return this.nugget(class_1856.method_8091((class_1935[])new class_1935[]{nugget}), nugget);
    }

    public MetalProcessingChainBuilder clump(class_1856 clumpIngredient, class_1792 clump) {
        this.clumpIngredient = clumpIngredient;
        this.clumpItem = clump;
        return this;
    }

    public MetalProcessingChainBuilder clump(class_6862<class_1792> clumpTag, class_1792 clump) {
        return this.clump(class_1856.method_8106(clumpTag), clump);
    }

    public MetalProcessingChainBuilder clump(class_1792 clump) {
        return this.clump(class_1856.method_8091((class_1935[])new class_1935[]{clump}), clump);
    }

    public MetalProcessingChainBuilder smallClump(class_1792 smallClump) {
        this.smallClumpItem = smallClump;
        return this;
    }

    public MetalProcessingChainBuilder centrifugeResult(class_1792 result, int amount) {
        this.centrifugeResult = result;
        this.centrifugeAmount = amount;
        return this;
    }

    public MetalProcessingChainBuilder centrifugeResult(class_1792 result) {
        return this.centrifugeResult(result, 1);
    }

    public MetalProcessingChainBuilder clumpByproduct(class_1792 byproduct) {
        this.clumpByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder dustByproduct(class_1792 byproduct) {
        this.dustByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder byproductAmount(int amount) {
        this.byproductAmount = amount;
        return this;
    }

    public MetalProcessingChainBuilder dust(class_1792 dust) {
        this.dustItem = dust;
        return this;
    }

    public MetalProcessingChainBuilder smallDust(class_1792 smallDust) {
        this.smallDustItem = smallDust;
        return this;
    }

    public MetalProcessingChainBuilder gem(class_1856 gemIngredient, class_1792 gem) {
        this.gemIngredient = gemIngredient;
        this.gemItem = gem;
        return this;
    }

    public MetalProcessingChainBuilder gem(class_6862<class_1792> gemTag, class_1792 gem) {
        return this.gem(class_1856.method_8106(gemTag), gem);
    }

    public MetalProcessingChainBuilder gem(class_1792 gem) {
        return this.gem(class_1856.method_8091((class_1935[])new class_1935[]{gem}), gem);
    }

    public MetalProcessingChainBuilder gemCatalyst(class_1856 gemCatalyst) {
        this.gemCatalyst = gemCatalyst;
        return this;
    }

    public MetalProcessingChainBuilder gemCatalyst(class_6862<class_1792> gemCatalyst) {
        return this.gemCatalyst(class_1856.method_8106(gemCatalyst));
    }

    public MetalProcessingChainBuilder gemCatalyst(class_1792 gemCatalyst) {
        return this.gemCatalyst(class_1856.method_8091((class_1935[])new class_1935[]{gemCatalyst}));
    }

    public MetalProcessingChainBuilder timeMultiplier(float timeMultiplier) {
        this.timeMultiplier = timeMultiplier;
        return this;
    }

    public MetalProcessingChainBuilder vanillaProcessing() {
        this.vanillaProcessing = true;
        return this;
    }

    public MetalProcessingChainBuilder skipCompacting() {
        this.skipCompactingRecipes = true;
        return this;
    }

    private void validate(String path) throws IllegalStateException {
        if (this.ore == null) {
            throw new IllegalStateException("ore is required for metal processing chain " + path);
        }
        if (this.rawOreItem == null) {
            throw new IllegalStateException("raw ore is required for metal processing chain " + path);
        }
        if ((this.dustItem != null || this.vanillaProcessing) && this.ingotItem == null) {
            throw new IllegalStateException("ingot is required if dust is provided or vanilla processing is required for metal processing chain " + path);
        }
        if ((this.smallClumpItem != null || this.smallDustItem != null) && this.nuggetItem == null) {
            throw new IllegalStateException("nugget item is required if small clump or small dust are provided for metal processing chain " + path);
        }
        if (this.centrifugeResult != null && this.centrifugeAmount < 1) {
            throw new IllegalStateException("centrifugeAmount must be >= 1 if centrifugeOutput is provided for metal processing chain " + path);
        }
        if (this.clumpItem != null && this.centrifugeResult == null && this.gemItem == null) {
            throw new IllegalStateException("either centrifugeResult or gemItem is required if clump is provided for metal processing chain " + path);
        }
    }

    public void export(class_8790 exporter) {
        this.validate(this.resourcePath + "ore/" + this.metalName);
        PulverizerRecipeBuilder.build().input(this.ore).result(this.rawOreItem, 2).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "ore/" + this.metalName);
        OritechRecipeBuilder grinderOreRecipe = GrinderRecipeBuilder.build().input(this.ore).result(this.rawOreItem, 2).time(140).timeMultiplier(this.timeMultiplier);
        if (this.rawOreByproduct != null) {
            grinderOreRecipe.result(this.rawOreByproduct);
        }
        grinderOreRecipe.export(exporter, this.resourcePath + "ore/" + this.metalName);
        if (this.dustItem != null) {
            PulverizerRecipeBuilder.build().input(this.rawOreIngredient).result(this.dustItem).result(this.firstNonNullOptional(this.smallDustItem, this.nuggetItem), 3).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "raw/" + this.metalName);
        }
        if (this.clumpItem != null || this.dustItem != null) {
            GrinderRecipeBuilder.build().input(this.rawOreIngredient).result(this.firstNonNull(this.clumpItem, this.dustItem)).result(this.firstNonNullOptional(this.smallClumpItem, this.smallDustItem, this.nuggetItem), 3).result((Optional<class_1792>)Optional.fromNullable((Object)this.clumpByproduct), this.byproductAmount).time(140).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "raw/" + this.metalName);
        }
        if (this.clumpItem != null || this.dustItem != null) {
            RefineryRecipeBuilder.build().input(this.rawOreIngredient).fluidInput((class_3611)FluidContent.STILL_SHEOL_FIRE.get(), 0.25f).result(this.firstNonNull(this.clumpItem, this.dustItem), 2).fluidOutput((class_3611)class_3612.field_15908, 0.1f).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "rawsheol/" + this.metalName);
        }
        if (this.clumpItem != null) {
            CentrifugeRecipeBuilder.build().input(this.clumpIngredient).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount : 1).result((Optional<class_1792>)Optional.fromNullable((Object)this.dustByproduct), this.byproductAmount).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "clump/" + this.metalName);
            CentrifugeFluidRecipeBuilder.build().input(this.clumpIngredient).fluidInput((class_3611)class_3612.field_15910).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount * 2 : 2).timeMultiplier(this.timeMultiplier * 1.5f).export(exporter, this.resourcePath + "clump/" + this.metalName);
            CentrifugeFluidRecipeBuilder.build().input(this.clumpIngredient).fluidInput((class_3611)FluidContent.STILL_SULFURIC_ACID.get()).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount * 3 : 3).fluidOutput((class_3611)FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).timeMultiplier(this.timeMultiplier * 1.5f).export(exporter, this.resourcePath + "clumpacid/" + this.metalName);
        }
        if (this.gemIngredient != null) {
            AtomicForgeRecipeBuilder.build().input(this.gemIngredient).input(this.gemCatalyst).input(this.gemCatalyst).result(this.dustItem, 2).time(20).export(exporter, this.resourcePath + "dust/" + this.metalName);
            FoundryRecipeBuilder.build().input(this.gemIngredient).input(this.gemIngredient).result(this.ingotItem, 3).export(exporter, this.resourcePath + "gem/" + this.metalName);
        }
        if (this.dustItem != null) {
            RecipeHelpers.addDustRecipe(exporter, this.ingotIngredient, this.dustItem, this.resourcePath + "dust/" + this.metalName);
        }
        if (this.smallDustItem != null) {
            RecipeHelpers.addDustRecipe(exporter, this.nuggetIngredient, this.smallDustItem, this.resourcePath + "smalldust/" + this.metalName);
        }
        if (this.vanillaProcessing) {
            if (this.dustItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.dustItem), class_7800.field_40642, (class_1935)this.ingotItem, 1.0f, 200, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.dustItem), class_7800.field_40642, (class_1935)this.ingotItem, 1.0f, 100, "oritech");
                OritechRecipeGenerator.method_47522((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)this.dustItem, (class_1935)this.smallDustItem);
            }
            if (this.smallDustItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.smallDustItem), class_7800.field_40642, (class_1935)this.nuggetItem, 0.5f, 50, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.smallDustItem), class_7800.field_40642, (class_1935)this.nuggetItem, 0.5f, 25, "oritech");
            }
            if (this.gemItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.gemItem), class_7800.field_40642, (class_1935)this.ingotItem, 1.0f, 200, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.gemItem), class_7800.field_40642, (class_1935)this.ingotItem, 1.0f, 100, "oritech");
            }
            if (this.clumpItem != null && this.smallClumpItem != null) {
                OritechRecipeGenerator.method_47522((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)this.clumpItem, (class_1935)this.smallClumpItem);
            }
            if (this.nuggetItem != null && !this.skipCompactingRecipes) {
                OritechRecipeGenerator.method_47522((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)this.ingotItem, (class_1935)this.nuggetItem);
            }
        }
    }

    private class_1792 firstNonNull(class_1792 ... items) {
        return (class_1792)Iterables.find(Arrays.asList(items), (Predicate)Predicates.notNull());
    }

    private Optional<class_1792> firstNonNullOptional(class_1792 ... items) {
        return Iterables.tryFind(Arrays.asList(items), (Predicate)Predicates.notNull());
    }
}

