/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public class ChargerBlockEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
EnergyApi.BlockProvider,
ItemApi.BlockProvider,
ScreenProvider,
ExtendedMenuProvider {
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    protected final DynamicEnergyStorage energyStorage;
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    private final SimpleFluidStorage fluidStorage;
    public final InOutInventoryStorage inventory;

    public ChargerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.CHARGER_BLOCK_ENTITY, pos, state);
        this.energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.charger.energyCapacity(), Oritech.CONFIG.charger.maxEnergyInsertion(), Oritech.CONFIG.charger.maxEnergyExtraction(), this::method_5431);
        this.fluidStorage = new SimpleFluidStorage(16L * FluidStackHooks.bucketAmount(), this::method_5431);
        this.inventory = new InOutInventoryStorage(2, this::method_5431, new InventorySlotAssignment(0, 1, 1, 1));
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        class_1799 outSlot;
        if (world.field_9236) {
            return;
        }
        if (this.inventory.method_5438(0).method_7960() || this.inventory.method_5438(0).method_7947() > 1) {
            return;
        }
        boolean isFull = true;
        long startEnergy = this.energyStorage.amount;
        long startFluid = this.fluidStorage.getAmount();
        if (!this.chargeItems()) {
            isFull = false;
        }
        if (!this.fillItems()) {
            isFull = false;
        }
        if (isFull && (outSlot = this.inventory.method_5438(1)).method_7960()) {
            this.inventory.method_5447(1, this.inventory.method_5438(0));
            this.inventory.method_5447(0, class_1799.field_8037);
        }
        if (this.fluidStorage.getAmount() != startFluid || this.energyStorage.amount != startEnergy) {
            ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.method_46558().method_1031(0.1, 0.1, 0.0), (Object)1);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        class_1262.method_5427((class_2487)nbt, (class_2371)this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
        class_1262.method_5429((class_2487)nbt, (class_2371)this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
    }

    private boolean chargeItems() {
        class_1799 heldStack = (class_1799)this.inventory.heldStacks.get(0);
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        EnergyApi.EnergyStorage slotEnergyContainer = EnergyApi.ITEM.find(stackRef);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
            return slotEnergyContainer.getAmount() >= slotEnergyContainer.getCapacity();
        }
        return true;
    }

    private boolean fillItems() {
        class_1799 heldStack = (class_1799)this.inventory.heldStacks.get(0);
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        FluidApi.FluidStorage slotFluidContainer = FluidApi.ITEM.find(stackRef);
        if (slotFluidContainer != null) {
            long moved = FluidApi.transferFirst(this.fluidStorage, slotFluidContainer, (long)((float)FluidStackHooks.bucketAmount() * 0.1f), false);
            return this.fluidStorage.getAmount() > 0L && moved == 0L;
        }
        return true;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.CHARGER_SCREEN;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 38));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 1024.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showArmor() {
        return true;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return this.fluidStorage;
    }
}

