/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.nocombatelytra.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import lol.sylvie.nocombatelytra.NoCombatElytra;
import lol.sylvie.nocombatelytra.config.ConfigRecord;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private ConfigRecord record = new ConfigRecord(30, false);

    public ConfigHandler(File file) {
        this.file = file;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((Object)this.record, (Appendable)writer);
        }
        catch (IOException e) {
            NoCombatElytra.LOGGER.error("IOException while trying to save config to disk!", (Throwable)e);
        }
    }

    public void load() {
        if (!this.file.exists()) {
            this.save();
        }
        try (FileReader reader = new FileReader(this.file);){
            this.record = (ConfigRecord)GSON.fromJson((Reader)reader, ConfigRecord.class);
        }
        catch (IOException e) {
            NoCombatElytra.LOGGER.error("IOException while trying to load config from disk!", (Throwable)e);
        }
        catch (RuntimeException e) {
            NoCombatElytra.LOGGER.error("RuntimeException while parsing config file. Is the file corrupted?", (Throwable)e);
        }
    }

    public ConfigRecord get() {
        return this.record;
    }
}

