/*
 * Decompiled with CFR 0.152.
 */
package mushroomvillagertrader.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mushroomvillagertrader.MushroomVillagerTraderMod;
import mushroomvillagertrader.init.MushroomVillagerTraderModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MushroomVillagerTraderModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"mushroom_villager_trader");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> MUSHROOM_TRADER = MushroomVillagerTraderModVillagerProfessions.registerProfession("mushroom_trader", () -> (Block)MushroomVillagerTraderModBlocks.MUSHROOM_TRADER_BLOCK.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.work_farmer")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> MUSHROOM_TRADER_MISC = MushroomVillagerTraderModVillagerProfessions.registerProfession("mushroom_trader_misc", () -> (Block)MushroomVillagerTraderModBlocks.MUSHROOM_TRADER_BLOCK_2.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.villager.work_farmer")));

    private static DeferredHolder<VillagerProfession, VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> MushroomVillagerTraderModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.value() == MushroomVillagerTraderModVillagerProfessions.POI_TYPES.get((Object)name).poiType.value();
            return new VillagerProfession("mushroom_villager_trader:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.forState((BlockState)block.defaultBlockState());
                if (existingCheck.isPresent()) {
                    MushroomVillagerTraderMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 1, 1);
                registerHelper.register(ResourceLocation.fromNamespaceAndPath((String)"mushroom_villager_trader", (String)name), (Object)poiType);
                entry.getValue().poiType = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

