/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class CustomBipedRenderer<T extends Mob, S extends HumanoidRenderState, M extends HumanoidModel<S>>
extends MobRenderer<T, S, M> {
    private static final ResourceLocation DEFAULT_RES_LOC = ResourceLocation.withDefaultNamespace((String)"textures/entity/steve.png");

    public CustomBipedRenderer(EntityRendererProvider.Context context, M humanoidModel, float shadowSize) {
        super(context, humanoidModel, shadowSize);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
    }

    public void extractRenderState(T mob, S state, float partialTick) {
        super.extractRenderState(mob, state, partialTick);
        CustomBipedRenderer.extractHumanoidRenderState(mob, state, partialTick, this.itemModelResolver);
        ((HumanoidRenderState)state).leftArmPose = this.getArmPose(mob, HumanoidArm.LEFT);
        ((HumanoidRenderState)state).rightArmPose = this.getArmPose(mob, HumanoidArm.RIGHT);
    }

    protected HumanoidModel.ArmPose getArmPose(T mob, HumanoidArm arm) {
        return HumanoidModel.ArmPose.EMPTY;
    }

    public static void extractHumanoidRenderState(LivingEntity entity, HumanoidRenderState reusedState, float partialTick, ItemModelResolver itemModelResolver) {
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)entity, (ArmedEntityRenderState)reusedState, (ItemModelResolver)itemModelResolver);
        reusedState.isCrouching = entity.isCrouching();
        reusedState.isFallFlying = entity.isFallFlying();
        reusedState.isVisuallySwimming = entity.isVisuallySwimming();
        reusedState.isPassenger = entity.isPassenger();
        reusedState.speedValue = 1.0f;
        if (reusedState.isFallFlying) {
            reusedState.speedValue = (float)entity.getDeltaMovement().lengthSqr();
            reusedState.speedValue /= 0.2f;
            reusedState.speedValue = reusedState.speedValue * reusedState.speedValue * reusedState.speedValue;
        }
        if (reusedState.speedValue < 1.0f) {
            reusedState.speedValue = 1.0f;
        }
        reusedState.attackTime = entity.getAttackAnim(partialTick);
        reusedState.swimAmount = entity.getSwimAmount(partialTick);
        reusedState.attackArm = CustomBipedRenderer.getAttackArm(entity);
        reusedState.useItemHand = entity.getUsedItemHand();
        reusedState.maxCrossbowChargeDuration = CrossbowItem.getChargeDuration((ItemStack)entity.getUseItem(), (LivingEntity)entity);
        reusedState.ticksUsingItem = entity.getTicksUsingItem();
        reusedState.isUsingItem = entity.isUsingItem();
        reusedState.elytraRotX = entity.elytraAnimationState.getRotX(partialTick);
        reusedState.elytraRotY = entity.elytraAnimationState.getRotY(partialTick);
        reusedState.elytraRotZ = entity.elytraAnimationState.getRotZ(partialTick);
        reusedState.headEquipment = CustomBipedRenderer.getEquipmentIfRenderable(entity, EquipmentSlot.HEAD);
        reusedState.chestEquipment = CustomBipedRenderer.getEquipmentIfRenderable(entity, EquipmentSlot.CHEST);
        reusedState.legsEquipment = CustomBipedRenderer.getEquipmentIfRenderable(entity, EquipmentSlot.LEGS);
        reusedState.feetEquipment = CustomBipedRenderer.getEquipmentIfRenderable(entity, EquipmentSlot.FEET);
    }

    private static ItemStack getEquipmentIfRenderable(LivingEntity entity, EquipmentSlot slot) {
        ItemStack itemstack = entity.getItemBySlot(slot);
        return HumanoidArmorLayer.shouldRender((ItemStack)itemstack, (EquipmentSlot)slot) ? itemstack.copy() : ItemStack.EMPTY;
    }

    private static HumanoidArm getAttackArm(LivingEntity entity) {
        HumanoidArm humanoidarm = entity.getMainArm();
        return entity.swingingArm == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.getOpposite();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull S state) {
        return DEFAULT_RES_LOC;
    }
}

