/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.instrumentalmobs.client.render.model.CymbalHuskModel;
import com.mrbysco.instrumentalmobs.client.render.state.CymbalRenderState;
import com.mrbysco.instrumentalmobs.entities.CymbalHusk;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;
import org.jetbrains.annotations.NotNull;

public class CymbalHuskRenderer
extends AbstractZombieRenderer<CymbalHusk, CymbalRenderState, CymbalHuskModel<CymbalRenderState>> {
    private static final ResourceLocation HUSK_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/husk.png");

    public CymbalHuskRenderer(EntityRendererProvider.Context context) {
        super(context, new CymbalHuskModel(context.bakeLayer(ModelLayers.HUSK)), new CymbalHuskModel(context.bakeLayer(ModelLayers.HUSK_BABY)), ArmorModelSet.bake((ArmorModelSet)ModelLayers.HUSK_ARMOR, (EntityModelSet)context.getModelSet(), CymbalHuskModel::new), ArmorModelSet.bake((ArmorModelSet)ModelLayers.HUSK_BABY_ARMOR, (EntityModelSet)context.getModelSet(), CymbalHuskModel::new));
    }

    @NotNull
    public CymbalRenderState createRenderState() {
        return new CymbalRenderState();
    }

    public void extractRenderState(@NotNull CymbalHusk husk, @NotNull CymbalRenderState state, float partialTick) {
        super.extractRenderState((Zombie)husk, (ZombieRenderState)state, partialTick);
        state.isClapping = husk.isClapping();
    }

    protected void scale(@NotNull CymbalRenderState state, PoseStack poseStack) {
        float size = 1.0625f;
        poseStack.scale(size, size, size);
        super.scale((LivingEntityRenderState)state, poseStack);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CymbalRenderState state) {
        return HUSK_LOCATION;
    }
}

