/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mrbysco.instrumentalmobs.client.render.layers.DrumLayer;
import com.mrbysco.instrumentalmobs.client.render.state.DrumRenderState;
import com.mrbysco.instrumentalmobs.entities.DrumZombie;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;

public class DrumZombieRenderer
extends AbstractZombieRenderer<DrumZombie, DrumRenderState, ZombieModel<DrumRenderState>> {
    public DrumZombieRenderer(EntityRendererProvider.Context context) {
        this(context, ModelLayers.ZOMBIE, ModelLayers.ZOMBIE_BABY, (ArmorModelSet<ModelLayerLocation>)ModelLayers.ZOMBIE_ARMOR, (ArmorModelSet<ModelLayerLocation>)ModelLayers.ZOMBIE_BABY_ARMOR);
        this.addLayer(new DrumLayer((RenderLayerParent<DrumRenderState, ZombieModel<DrumRenderState>>)this));
    }

    public DrumZombieRenderer(EntityRendererProvider.Context context, ModelLayerLocation zombie, ModelLayerLocation baby, ArmorModelSet<ModelLayerLocation> armor, ArmorModelSet<ModelLayerLocation> armorBaby) {
        super(context, new ZombieModel(context.bakeLayer(zombie)), new ZombieModel(context.bakeLayer(baby)), ArmorModelSet.bake(armor, (EntityModelSet)context.getModelSet(), ZombieModel::new), ArmorModelSet.bake(armorBaby, (EntityModelSet)context.getModelSet(), ZombieModel::new));
    }

    @NotNull
    public DrumRenderState createRenderState() {
        return new DrumRenderState();
    }

    public void extractRenderState(@NotNull DrumZombie zombie, @NotNull DrumRenderState state, float partialTick) {
        super.extractRenderState((Zombie)zombie, (ZombieRenderState)state, partialTick);
        this.itemModelResolver.updateForLiving(state.chestEquipment, zombie.getItemBySlot(EquipmentSlot.CHEST), ItemDisplayContext.NONE, (LivingEntity)zombie);
    }
}

