/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.instrumentalmobs.client.render.layers.FrenchHornCreeperCharge;
import com.mrbysco.instrumentalmobs.client.render.layers.FrenchHornLayer;
import com.mrbysco.instrumentalmobs.client.render.model.FrenchHornCreeperModel;
import com.mrbysco.instrumentalmobs.client.render.state.FrenchRenderState;
import com.mrbysco.instrumentalmobs.entities.FrenchHornCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;

public class FrenchHornCreeperRenderer
extends MobRenderer<FrenchHornCreeper, FrenchRenderState, FrenchHornCreeperModel> {
    private static final ResourceLocation CREEPER_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");

    public FrenchHornCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new FrenchHornCreeperModel(context.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new FrenchHornCreeperCharge((RenderLayerParent<FrenchRenderState, FrenchHornCreeperModel>)this, context.getModelSet()));
        this.addLayer(new FrenchHornLayer((RenderLayerParent<FrenchRenderState, FrenchHornCreeperModel>)this));
    }

    protected void scale(FrenchRenderState state, PoseStack poseStack) {
        float f = state.swelling;
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(FrenchRenderState state) {
        float f = state.swelling;
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    @NotNull
    public FrenchRenderState createRenderState() {
        return new FrenchRenderState();
    }

    public void extractRenderState(@NotNull FrenchHornCreeper hornCreeper, @NotNull FrenchRenderState state, float partialTick) {
        super.extractRenderState((LivingEntity)hornCreeper, (LivingEntityRenderState)state, partialTick);
        state.swelling = hornCreeper.getSwelling(partialTick);
        state.isPowered = hornCreeper.isPowered();
        this.itemModelResolver.updateForLiving(state.heldItem, hornCreeper.getItemHeldByArm(HumanoidArm.RIGHT), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (LivingEntity)hornCreeper);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FrenchRenderState state) {
        return CREEPER_TEXTURES;
    }
}

