/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mrbysco.instrumentalmobs.client.render.layers.MaracaSpiderEyesLayer;
import com.mrbysco.instrumentalmobs.client.render.layers.MaracasLayer;
import com.mrbysco.instrumentalmobs.client.render.model.MaracaSpiderModel;
import com.mrbysco.instrumentalmobs.client.render.state.MaracaRenderState;
import com.mrbysco.instrumentalmobs.entities.MaracaSpider;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;

public class MaracaSpiderRenderer
extends MobRenderer<MaracaSpider, MaracaRenderState, MaracaSpiderModel> {
    private static final ResourceLocation SPIDER_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/spider/spider.png");

    public MaracaSpiderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MaracaSpiderModel(context.bakeLayer(ModelLayers.SPIDER)), 1.0f);
        this.addLayer((RenderLayer)new MaracaSpiderEyesLayer((RenderLayerParent<MaracaRenderState, MaracaSpiderModel>)this));
        this.addLayer(new MaracasLayer((RenderLayerParent<MaracaRenderState, MaracaSpiderModel>)this));
    }

    @NotNull
    public MaracaRenderState createRenderState() {
        return new MaracaRenderState();
    }

    public void extractRenderState(@NotNull MaracaSpider spider, @NotNull MaracaRenderState state, float partialTick) {
        super.extractRenderState((LivingEntity)spider, (LivingEntityRenderState)state, partialTick);
        if (state instanceof MaracaRenderState) {
            MaracaRenderState maracaState = state;
            maracaState.isAttacking = spider.isAttacking();
            this.itemModelResolver.updateForLiving(maracaState.mainItem, spider.getMainHandItem(), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (LivingEntity)spider);
            this.itemModelResolver.updateForLiving(maracaState.offItem, spider.getOffhandItem(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (LivingEntity)spider);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MaracaRenderState state) {
        return SPIDER_TEXTURES;
    }

    protected float getFlipDegrees() {
        return 180.0f;
    }
}

