/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mrbysco.instrumentalmobs.client.render.layers.MicrophoneLayer;
import com.mrbysco.instrumentalmobs.client.render.state.MicrophoneRenderState;
import com.mrbysco.instrumentalmobs.entities.MicrophoneGhast;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;

public class MicrophoneGhastRenderer
extends MobRenderer<MicrophoneGhast, MicrophoneRenderState, GhastModel> {
    private static final ResourceLocation GHAST_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/ghast/ghast.png");
    private static final ResourceLocation GHAST_SHOOTING_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/ghast/ghast_shooting.png");

    public MicrophoneGhastRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GhastModel(context.bakeLayer(ModelLayers.GHAST)), 1.5f);
        this.addLayer(new MicrophoneLayer((RenderLayerParent<MicrophoneRenderState, GhastModel>)this));
    }

    @NotNull
    public MicrophoneRenderState createRenderState() {
        return new MicrophoneRenderState();
    }

    public void extractRenderState(@NotNull MicrophoneGhast ghast, @NotNull MicrophoneRenderState state, float partialTick) {
        super.extractRenderState((LivingEntity)ghast, (LivingEntityRenderState)state, partialTick);
        state.isCharging = ghast.isCharging();
        state.isSinging = ghast.isSinging();
        this.itemModelResolver.updateForLiving(state.headItem, ghast.getItemBySlot(EquipmentSlot.HEAD), ItemDisplayContext.NONE, (LivingEntity)ghast);
    }

    @NotNull
    public ResourceLocation getTextureLocation(MicrophoneRenderState state) {
        return state.isCharging ? GHAST_SHOOTING_LOCATION : GHAST_LOCATION;
    }
}

