/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mrbysco.instrumentalmobs.client.render.layers.TubaEndermanEyesLayer;
import com.mrbysco.instrumentalmobs.client.render.layers.TubaEndermanHeldItemLayer;
import com.mrbysco.instrumentalmobs.client.render.model.TubaEndermanModel;
import com.mrbysco.instrumentalmobs.entities.TubaEnderman;
import java.util.Random;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EndermanRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TubaEndermanRenderer
extends MobRenderer<TubaEnderman, EndermanRenderState, TubaEndermanModel<EndermanRenderState>> {
    private static final ResourceLocation ENDERMAN_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderman/enderman.png");
    private final Random rnd = new Random();

    public TubaEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, new TubaEndermanModel(context.bakeLayer(ModelLayers.ENDERMAN)), 0.5f);
        this.addLayer((RenderLayer)new TubaEndermanEyesLayer(this));
        this.addLayer(new TubaEndermanHeldItemLayer((RenderLayerParent<EndermanRenderState, TubaEndermanModel<EndermanRenderState>>)this));
    }

    @NotNull
    public Vec3 getRenderOffset(EndermanRenderState state) {
        if (state.isCreepy) {
            return new Vec3(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.getRenderOffset((EntityRenderState)state);
    }

    @NotNull
    public EndermanRenderState createRenderState() {
        return new EndermanRenderState();
    }

    public void extractRenderState(@NotNull TubaEnderman enderman, @NotNull EndermanRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)enderman, (LivingEntityRenderState)state, partialTicks);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)enderman, (HumanoidRenderState)state, (float)partialTicks, (ItemModelResolver)this.itemModelResolver);
        state.isCreepy = enderman.isCreepy();
        state.carriedBlock = enderman.getCarriedBlock();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EndermanRenderState state) {
        return ENDERMAN_TEXTURES;
    }
}

