/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mrbysco.instrumentalmobs.client.render.CustomBipedRenderer;
import com.mrbysco.instrumentalmobs.client.render.layers.HeldBoneLayer;
import com.mrbysco.instrumentalmobs.client.render.model.XylophoneSkeletonModel;
import com.mrbysco.instrumentalmobs.client.render.state.XylophoneRenderState;
import com.mrbysco.instrumentalmobs.entities.XylophoneSkeleton;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class XylophoneSkeletonRenderer
extends CustomBipedRenderer<XylophoneSkeleton, XylophoneRenderState, XylophoneSkeletonModel> {
    private static final ResourceLocation SKELETON_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");

    public XylophoneSkeletonRenderer(EntityRendererProvider.Context context) {
        super(context, new XylophoneSkeletonModel(context.bakeLayer(ModelLayers.SKELETON)), 0.5f);
        this.addLayer(new HeldBoneLayer((RenderLayerParent<XylophoneRenderState, XylophoneSkeletonModel>)this));
    }

    @NotNull
    public XylophoneRenderState createRenderState() {
        return new XylophoneRenderState();
    }

    @Override
    public void extractRenderState(@NotNull XylophoneSkeleton skeleton, @NotNull XylophoneRenderState state, float partialTick) {
        super.extractRenderState(skeleton, state, partialTick);
        state.isPlaying = skeleton.isPlayingInstrument() && skeleton.getMainHandItem().is(Items.BONE);
        state.isAggressive = skeleton.isAggressive();
        state.isShaking = skeleton.isShaking();
        state.isHoldingBow = skeleton.getMainHandItem().is(Items.BOW);
    }

    protected boolean isShaking(XylophoneRenderState state) {
        return state.isShaking;
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull XylophoneRenderState state) {
        return SKELETON_TEXTURES;
    }
}

