/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.client.render.model.XylophoneSkeletonModel;
import com.mrbysco.instrumentalmobs.client.render.state.XylophoneRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class HeldBoneLayer
extends RenderLayer<XylophoneRenderState, XylophoneSkeletonModel> {
    public HeldBoneLayer(RenderLayerParent<XylophoneRenderState, XylophoneSkeletonModel> layerParent) {
        super(layerParent);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, XylophoneRenderState state, float xRot, float yRot) {
        ItemStackRenderState itemstack1;
        boolean flag = state.mainArm == HumanoidArm.RIGHT;
        ItemStackRenderState itemstack = flag ? state.leftHandItem : state.rightHandItem;
        ItemStackRenderState itemStackRenderState = itemstack1 = flag ? state.rightHandItem : state.leftHandItem;
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            poseStack.pushPose();
            if (state.isBaby) {
                float f = 0.5f;
                poseStack.translate(0.0f, 0.75f, 0.0f);
                poseStack.scale(f, f, f);
            }
            this.renderHeldItem(state, itemstack1, HumanoidArm.LEFT, poseStack, submitNodeCollector, packedLight);
            this.renderHeldItem(state, itemstack, HumanoidArm.RIGHT, poseStack, submitNodeCollector, packedLight);
            poseStack.popPose();
        }
    }

    private void renderHeldItem(XylophoneRenderState state, ItemStackRenderState stack, HumanoidArm arm, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            if (state.isCrouching) {
                poseStack.translate(0.0f, 0.2f, 0.0f);
            }
            ((XylophoneSkeletonModel)this.getParentModel()).translateToHand(state, arm, poseStack);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            boolean flag = arm == HumanoidArm.LEFT;
            boolean flag2 = state.isPlaying;
            if (flag2) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                poseStack.translate(0.0f, -0.225f, -0.5f);
                poseStack.mulPose((Quaternionfc)Axis.of((Vector3f)new Vector3f(1.0f, flag ? -0.2f : 0.2f, flag ? -0.2f : 0.2f)).rotationDegrees(45.0f));
            }
            poseStack.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            stack.submit(poseStack, submitNodeCollector, packedLight, OverlayTexture.NO_OVERLAY, state.outlineColor);
            poseStack.popPose();
        }
    }
}

