/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.client.render.model.MaracaSpiderModel;
import com.mrbysco.instrumentalmobs.client.render.state.MaracaRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Quaternionfc;

public class MaracasLayer
extends RenderLayer<MaracaRenderState, MaracaSpiderModel> {
    public MaracasLayer(RenderLayerParent<MaracaRenderState, MaracaSpiderModel> layerParent) {
        super(layerParent);
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, MaracaRenderState state, float xRot, float yRot) {
        ItemStackRenderState stack = state.mainItem;
        ItemStackRenderState otherStack = state.offItem;
        if (!stack.isEmpty() || !otherStack.isEmpty()) {
            poseStack.pushPose();
            this.renderHeldItem(state, stack, HumanoidArm.LEFT, poseStack, submitNodeCollector, packedLight);
            this.renderHeldItem(state, otherStack, HumanoidArm.RIGHT, poseStack, submitNodeCollector, packedLight);
            poseStack.popPose();
        }
    }

    private void renderHeldItem(MaracaRenderState state, ItemStackRenderState stack, HumanoidArm handSide, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            ((MaracaSpiderModel)this.getParentModel()).translateToHand((EntityRenderState)state, handSide, poseStack);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            boolean flag = handSide == HumanoidArm.LEFT;
            poseStack.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            stack.submit(poseStack, submitNodeCollector, packedLight, OverlayTexture.NO_OVERLAY, state.outlineColor);
            poseStack.popPose();
        }
    }
}

