/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.client.render.state.MaracaRenderState;
import java.util.Random;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MaracaSpiderModel
extends EntityModel<MaracaRenderState>
implements ArmedModel {
    private Random random = new Random();
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart rightMiddleFrontLeg;
    private final ModelPart leftMiddleFrontLeg;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;

    public MaracaSpiderModel(ModelPart part) {
        super(part);
        this.head = part.getChild("head");
        this.rightHindLeg = part.getChild("right_hind_leg");
        this.leftHindLeg = part.getChild("left_hind_leg");
        this.rightMiddleHindLeg = part.getChild("right_middle_hind_leg");
        this.leftMiddleHindLeg = part.getChild("left_middle_hind_leg");
        this.rightMiddleFrontLeg = part.getChild("right_middle_front_leg");
        this.leftMiddleFrontLeg = part.getChild("left_middle_front_leg");
        this.rightFrontLeg = part.getChild("right_front_leg");
        this.leftFrontLeg = part.getChild("left_front_leg");
    }

    public void setupAnim(@NotNull MaracaRenderState state) {
        super.setupAnim((Object)state);
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        float f = state.walkAnimationPos * 0.6662f;
        float f1 = state.walkAnimationSpeed;
        float f2 = -(Mth.cos((float)(f * 2.0f + 0.0f)) * 0.4f) * f1;
        float f3 = -(Mth.cos((float)(f * 2.0f + (float)Math.PI)) * 0.4f) * f1;
        float f4 = -(Mth.cos((float)(f * 2.0f + 1.5707964f)) * 0.4f) * f1;
        float f5 = -(Mth.cos((float)(f * 2.0f + 4.712389f)) * 0.4f) * f1;
        float f6 = Math.abs(Mth.sin((float)(f + 0.0f)) * 0.4f) * f1;
        float f7 = Math.abs(Mth.sin((float)(f + (float)Math.PI)) * 0.4f) * f1;
        float f8 = Math.abs(Mth.sin((float)(f + 1.5707964f)) * 0.4f) * f1;
        float f9 = Math.abs(Mth.sin((float)(f + 4.712389f)) * 0.4f) * f1;
        this.rightHindLeg.yRot += f2;
        this.leftHindLeg.yRot -= f2;
        this.rightMiddleHindLeg.yRot += f3;
        this.leftMiddleHindLeg.yRot -= f3;
        this.rightMiddleFrontLeg.yRot += f4;
        this.leftMiddleFrontLeg.yRot -= f4;
        this.rightFrontLeg.yRot += f5;
        this.leftFrontLeg.yRot -= f5;
        this.rightHindLeg.zRot += f6;
        this.leftHindLeg.zRot -= f6;
        this.rightMiddleHindLeg.zRot += f7;
        this.leftMiddleHindLeg.zRot -= f7;
        this.rightMiddleFrontLeg.zRot += f8;
        this.leftMiddleFrontLeg.zRot -= f8;
        this.rightFrontLeg.zRot += f9;
        this.leftFrontLeg.zRot -= f9;
        if (state.isAttacking && this.random.nextFloat() > 0.5f) {
            float randAngle = this.random.nextInt(45);
            this.rightFrontLeg.yRot += randAngle;
            this.leftFrontLeg.yRot += randAngle;
        }
    }

    protected ModelPart getLegForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.rightFrontLeg : this.leftFrontLeg;
    }

    public void translateToHand(EntityRenderState renderState, HumanoidArm arm, PoseStack poseStack) {
        this.getLegForSide(arm).translateAndRotate(poseStack);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(-90.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(90.0f));
        boolean flag = arm == HumanoidArm.LEFT;
        poseStack.mulPose((Quaternionfc)Axis.of((Vector3f)new Vector3f(0.0f, flag ? -0.23f : 0.23f, flag ? -0.23f : 0.23f)).rotationDegrees(90.0f));
        poseStack.translate(flag ? 0.315f : -0.6125f, flag ? -0.125f : -1.3125f, flag ? -0.6875f : 0.425f);
    }
}

