/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.datagen.assets;

import com.mrbysco.instrumentalmobs.registration.InstrumentalEntities;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.InstrumentalSounds;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class InstrumentalLanguageProvider
extends LanguageProvider {
    public InstrumentalLanguageProvider(PackOutput packOutput) {
        super(packOutput, "instrumentalmobs", "en_us");
    }

    protected void addTranslations() {
        this.add("instrumentalmobs.config.title", "Instrumental Mobs config");
        this.add("itemGroup.instrumentalmobs", "Instrumental Mobs");
        this.addItem(InstrumentalRegistry.XYLOPHONE, "Xylophone");
        this.addItem(InstrumentalRegistry.TUBA, "Tuba");
        this.addItem(InstrumentalRegistry.FRENCH_HORN, "French Horn");
        this.addItem(InstrumentalRegistry.DRUM_ITEM, "Drum");
        this.addItem(InstrumentalRegistry.CYMBAL, "Cymbal");
        this.addItem(InstrumentalRegistry.CYMBALS, "Cymbals");
        this.addItem(InstrumentalRegistry.MARACA, "Maraca");
        this.addItem(InstrumentalRegistry.MARACAS, "Maracas");
        this.addItem(InstrumentalRegistry.MICROPHONE, "Microphone");
        this.addItem(InstrumentalRegistry.TRUMPET, "Trumpet");
        this.addItem(InstrumentalRegistry.XYLOPHONE_SKELETON_SPAWN_EGG, "Xylophone Skeleton Spawn Egg");
        this.addItem(InstrumentalRegistry.TRUMPET_SKELETON_SPAWN_EGG, "Trumpet Skeleton Spawn Egg");
        this.addItem(InstrumentalRegistry.FRENCH_HORN_CREEPER_SPAWN_EGG, "French Horn Creeper Spawn Egg");
        this.addItem(InstrumentalRegistry.TUBA_ENDERMAN_SPAWN_EGG, "Tuba Enderman Spawn Egg");
        this.addItem(InstrumentalRegistry.DRUM_ZOMBIE_SPAWN_EGG, "Drum Zombie Spawn Egg");
        this.addItem(InstrumentalRegistry.CYMBAL_HUSK_SPAWN_EGG, "Cymbal Husk Spawn Egg");
        this.addItem(InstrumentalRegistry.MARACA_SPIDER_SPAWN_EGG, "Maraca Spider Spawn Egg");
        this.addItem(InstrumentalRegistry.MICROPHONE_GHAST_SPAWN_EGG, "Microphone Ghast Spawn Egg");
        this.addBlock(InstrumentalRegistry.DRUM_BLOCK, "Drum");
        this.addEntityType(InstrumentalEntities.XYLOPHONE_SKELETON, "Xylophone Skeleton");
        this.addEntityType(InstrumentalEntities.FRENCH_HORN_CREEPER, "French Horn Creeper");
        this.addEntityType(InstrumentalEntities.TUBA_ENDERMAN, "Tuba Enderman");
        this.addEntityType(InstrumentalEntities.DRUM_ZOMBIE, "Drum Zombie");
        this.addEntityType(InstrumentalEntities.CYMBAL_HUSK, "Cymbal Husk");
        this.addEntityType(InstrumentalEntities.MARACA_SPIDER, "Maraca Spider");
        this.addEntityType(InstrumentalEntities.MICROPHONE_GHAST, "Microphone Ghast");
        this.addEntityType(InstrumentalEntities.SOUND_WAVE, "Soundwave");
        this.addEntityType(InstrumentalEntities.MICROPHONE_WAVE, "Soundwave");
        this.addSubtitle(InstrumentalSounds.XYLOPHONE_SOUND.get(), "Skeleton plays their ribs like a xylophone");
        this.addSubtitle(InstrumentalSounds.TUBA_SOUND.get(), "Tuba Plays");
        this.addSubtitle(InstrumentalSounds.FRENCH_HORN_SOUND.get(), "French Horn Plays");
        this.addSubtitle(InstrumentalSounds.DRUM_SOUND.get(), "Drum sounds");
        this.addSubtitle(InstrumentalSounds.SINGLE_DRUM_SOUND.get(), "Drum sounds");
        this.addSubtitle(InstrumentalSounds.CYMBALS_SOUND.get(), "A Cymbal Crash sounds");
        this.addSubtitle(InstrumentalSounds.MARACA_SOUND.get(), "Maraca sounds");
        this.addSubtitle(InstrumentalSounds.TRUMPET_SOUND.get(), "Doot Doot");
        this.add("death.attack.instrumentalmobs.sound", "%1$s was deafened");
        this.add("death.attack.instrumentalmobs.sound.player", "%1$s was deafened trying to escape %2$s");
        this.addAdvancement("root", "Instrumental Mobs", "Getting instrumental with mobs");
        this.addAdvancement("cymbals", "Cymbals", "*CRASH* What did you say? *CRASH* I can't hear you due to the *CRASH* noise...");
        this.addAdvancement("drum", "Drum", "You've heard of the Little Drummer Boy, well now you've met my Drummer Zombie(s) *Badumnn Tsss*");
        this.addAdvancement("french_horn", "French Horn", "I see you met my French Horn creeper(s)? Had fun??");
        this.addAdvancement("maracas", "Maracas", "*tssch* La Cucaracha *tssch*");
        this.addAdvancement("microphone", "Microphone", "Just scream...");
        this.addAdvancement("tuba", "Tuba", "Teleporting musicians... not fair *tuba noise*");
        this.addAdvancement("xylophone", "Xylophone", "Did you enjoy the skeletons?");
        this.addAdvancement("trumpet", "Trumpet", "Doot doot!");
        this.addConfig("general", "General", "General Settings");
        this.addConfig("mobsReact", "Mobs React", "Mobs react upon usage of the instruments [default: true]");
        this.addConfig("instrumentRange", "Instrument Range", "The area in which the instruments react with mobs. [default: 10.0]");
        this.addConfig("soundDamageChance", "Sound Damage Chance", "The chance of instrument sounds damaging mobs after pushing. [default: 0.35]");
        this.addConfig("instrumentDropChance", "Instrument Drop Chance", "The chance of instrument dropping from a mob holding one [default: 0.5]");
        this.addConfig("instrumentHurtChance", "Instrument Hurt Chance", "The chance of instrument hurting nearby entities upon sounding [default: 0.3]");
    }

    public void addSubtitle(SoundEvent sound, String name) {
        String path = "instrumentalmobs.subtitle." + sound.location().getPath();
        this.add(path, name);
    }

    private void addAdvancement(String id, String name, String description) {
        String prefix = "advancement.instrumentalmobs.";
        this.add(prefix + id + ".title", name);
        this.add(prefix + id + ".desc", description);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("instrumentalmobs.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("instrumentalmobs.configuration." + path + ".tooltip", description);
        }
    }
}

