/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.datagen.data;

import com.mrbysco.instrumentalmobs.Constants;
import com.mrbysco.instrumentalmobs.registration.InstrumentalEntities;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.RegistryObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InstrumentalAdvancementProvider
extends AdvancementProvider {
    public InstrumentalAdvancementProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, List.of(new InstrumentalAdvancements()));
    }

    public static class InstrumentalAdvancements
    implements AdvancementSubProvider {
        public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer) {
            HolderLookup.RegistryLookup holdergetter = provider.lookupOrThrow(Registries.ENTITY_TYPE);
            AdvancementHolder root = Advancement.Builder.advancement().display(InstrumentalAdvancements.rootDisplay((ItemLike)Items.NOTE_BLOCK, InstrumentalAdvancements.advancementPrefix("root.title"), InstrumentalAdvancements.advancementPrefix("root.desc"), ResourceLocation.withDefaultNamespace((String)"textures/block/yellow_wool.png"))).addCriterion("french_horn_creeper", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.FRENCH_HORN_CREEPER.get()))).addCriterion("tuba_enderman", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.TUBA_ENDERMAN.get()))).addCriterion("drum_zombie", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.DRUM_ZOMBIE.get()))).addCriterion("cymbal_husk", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.CYMBAL_HUSK.get()))).addCriterion("xylophone_skeleton", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.XYLOPHONE_SKELETON.get()))).addCriterion("maraca_spider", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.MARACA_SPIDER.get()))).addCriterion("microphone_ghast", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)holdergetter, InstrumentalEntities.MICROPHONE_GHAST.get()))).requirements(AdvancementRequirements.Strategy.OR).save(consumer, InstrumentalAdvancements.rootID("root"));
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.CYMBALS, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.DRUM_ITEM, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.FRENCH_HORN, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.MARACAS, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.MICROPHONE, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.TUBA, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.XYLOPHONE, root);
            InstrumentalAdvancements.addInstrumentAdvancement(consumer, InstrumentalRegistry.TRUMPET, root);
        }

        public static void addInstrumentAdvancement(Consumer<AdvancementHolder> consumer, RegistryObject<Item> registryObject, AdvancementHolder root) {
            ResourceLocation registryLocation = registryObject.getId();
            Item item = registryObject.get();
            if (registryLocation != null) {
                Advancement.Builder.advancement().display(InstrumentalAdvancements.simpleDisplay((ItemLike)item, registryLocation.getPath())).parent(root).addCriterion("instrument", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, InstrumentalAdvancements.rootID(registryLocation.getPath()));
            }
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(new ClientAsset.ResourceTexture(background)), AdvancementType.TASK, true, true, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)InstrumentalAdvancements.advancementPrefix(name + ".title")), (Component)Component.translatable((String)InstrumentalAdvancements.advancementPrefix(name + ".desc")), Optional.empty(), AdvancementType.TASK, true, false, false);
        }

        private static String advancementPrefix(String name) {
            return "advancement.instrumentalmobs." + name;
        }

        private static String rootID(String name) {
            return Constants.modLoc("main/" + name).toString();
        }
    }
}

