/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.goals.InstrumentAttackGoal;
import com.mrbysco.instrumentalmobs.platform.Services;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.InstrumentalSounds;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TubaEnderman
extends EnderMan
implements IInstrumentalMobs {
    private final InstrumentAttackGoal playOnCollideGoal = new InstrumentAttackGoal((PathfinderMob)this, 1.0, false, InstrumentalSounds.TUBA_SOUND);

    public TubaEnderman(EntityType<? extends TubaEnderman> type, Level level) {
        super(type, level);
        this.reassessWeaponGoal();
    }

    private void reassessWeaponGoal() {
        if (this.level() != null && !this.level().isClientSide()) {
            this.goalSelector.removeGoal((Goal)this.playOnCollideGoal);
            ItemStack itemstack = this.getMainHandItem();
            if (itemstack.getItem() == InstrumentalRegistry.TUBA.get()) {
                this.goalSelector.addGoal(7, (Goal)this.playOnCollideGoal);
            }
        }
    }

    public void playStareSound() {
        if (this.tickCount >= this.lastStareSound + 400) {
            this.lastStareSound = this.tickCount;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ENDERMAN_STARE, this.getSoundSource(), 2.5f, 1.0f, false);
                if ((double)this.getRandom().nextFloat() < 0.3) {
                    this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), InstrumentalSounds.TUBA_SOUND.get(), this.getSoundSource(), 2.5f, 1.0f, false);
                }
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new StareGoal(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new LookForPlayerGOal(this, (arg_0, arg_1) -> ((TubaEnderman)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    private boolean isLookingAtMe(Player player) {
        ItemStack itemstack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (Services.PLATFORM.isEnderMask(itemstack, player, this)) {
            return false;
        }
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && player.hasLineOfSight((Entity)this);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)InstrumentalRegistry.TUBA.get()));
        this.setDropChance(EquipmentSlot.MAINHAND, this.getDropChance());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = serverLevelAccessor.getRandom();
        spawnGroupData = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        this.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        this.reassessWeaponGoal();
        return spawnGroupData;
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.reassessWeaponGoal();
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        super.setItemSlot(equipmentSlot, itemStack);
        if (!this.level().isClientSide()) {
            this.reassessWeaponGoal();
        }
    }

    public boolean isBeingStaredBy(Player player) {
        return !LivingEntity.PLAYER_NOT_WEARING_DISGUISE_ITEM.test(player) ? false : this.isLookingAtMe((LivingEntity)player, 0.025, true, false, new double[]{this.getEyeY()});
    }

    static class StareGoal
    extends Goal {
        private final TubaEnderman enderman;
        private LivingEntity targetPlayer;

        public StareGoal(TubaEnderman endermanIn) {
            this.enderman = endermanIn;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.targetPlayer = this.enderman.getTarget();
            if (!(this.targetPlayer instanceof Player)) {
                return false;
            }
            double d0 = this.targetPlayer.distanceToSqr((Entity)this.enderman);
            return !(d0 > 256.0) && this.enderman.isLookingAtMe((Player)this.targetPlayer);
        }

        public void start() {
            this.enderman.getNavigation().stop();
        }

        public void tick() {
            this.enderman.getLookControl().setLookAt(this.targetPlayer.getX(), this.targetPlayer.getEyeY(), this.targetPlayer.getZ());
        }
    }

    static class LookForPlayerGOal
    extends NearestAttackableTargetGoal<Player> {
        private final TubaEnderman enderman;
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();
        private final TargetingConditions.Selector isAngerInducing;

        public LookForPlayerGOal(TubaEnderman tubaEnderman, @Nullable TargetingConditions.Selector selector) {
            super((Mob)tubaEnderman, Player.class, 10, false, false, selector);
            this.enderman = tubaEnderman;
            this.isAngerInducing = (stared, serverLevel) -> (tubaEnderman.isBeingStaredBy((Player)stared) || tubaEnderman.isAngryAt(stared, serverLevel)) && !tubaEnderman.hasIndirectPassenger((Entity)stared);
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(this.isAngerInducing);
        }

        public boolean canUse() {
            this.pendingTarget = LookForPlayerGOal.getServerLevel((Entity)this.enderman).getNearestPlayer(this.startAggroTargetConditions.range(this.getFollowDistance()), (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void start() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void stop() {
            this.pendingTarget = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget, LookForPlayerGOal.getServerLevel((Entity)this.enderman))) {
                    return false;
                }
                this.enderman.lookAt((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.target != null) {
                if (this.enderman.hasIndirectPassenger((Entity)this.target)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.test(LookForPlayerGOal.getServerLevel((Entity)this.enderman), (LivingEntity)this.enderman, this.target)) {
                    return true;
                }
            }
            return super.canContinueToUse();
        }

        public void tick() {
            if (this.enderman.getTarget() == null) {
                super.setTarget((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.target = this.pendingTarget;
                    this.pendingTarget = null;
                    super.start();
                }
            } else {
                if (this.target != null && !this.enderman.isPassenger()) {
                    if (this.enderman.isLookingAtMe((Player)this.target)) {
                        if (this.target.distanceToSqr((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.target.distanceToSqr((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.target)) {
                        this.teleportTime = 0;
                    }
                }
                super.tick();
            }
        }
    }
}

